/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\r\u001b\u0003\u0003y\u0002\u0002\u0003\u0017\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011m\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!)1\t\u0001C\u0001\t\"9\u0001\n\u0001b\u0001\n\u0013I\u0005B\u0002*\u0001A\u0003%!\nC\u0004T\u0001\t\u0007I\u0011B%\t\rQ\u0003\u0001\u0015!\u0003K\u0011\u001d)\u0006\u00011A\u0005\nuBqA\u0016\u0001A\u0002\u0013%q\u000b\u0003\u0004^\u0001\u0001\u0006KA\u0010\u0005\u0006E\u0002!\ta\u0019\u0005\u0006I\u0002!\t!\u0010\u0005\u0006K\u0002!\tA\u001a\u0005\u0006O\u0002!\ta\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006i\u00021\ta\u0019\u0005\u0006k\u0002!\te\u0019\u0005\u0006m\u0002!\t!P\u0004\boj\t\t\u0011#\u0001y\r\u001dI\"$!A\t\u0002eDQa\u0011\f\u0005\u0002uDqA \f\u0012\u0002\u0013\u0005qP\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$'BA\u000e\u001d\u0003\u0015)H/\u001b7t\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0004\u0001\u0001B\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007)\"\u0014X-\u00193\u0011\u0005%RS\"\u0001\u000e\n\u0005-R\"a\u0002'pO\u001eLgnZ\u0001\u0005]\u0006lW-F\u0001/!\ty\u0003H\u0004\u00021mA\u0011\u0011\u0007N\u0007\u0002e)\u00111GH\u0001\u0007yI|w\u000e\u001e \u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oQ\nQA\\1nK\u0002\nq\"[:J]R,'O];qi&\u0014G.Z\u000b\u0002}A\u0011q\bQ\u0007\u0002i%\u0011\u0011\t\u000e\u0002\b\u0005>|G.Z1o\u0003AI7/\u00138uKJ\u0014X\u000f\u001d;jE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001a;\u0005CA\u0015\u0001\u0011\u0015aS\u00011\u0001/\u0011\u001daT\u0001%AA\u0002y\n\u0011c\u001d5vi\u0012|wO\\%oSRL\u0017\r^3e+\u0005Q\u0005CA&Q\u001b\u0005a%BA'O\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001f\u0012\nA!\u001e;jY&\u0011\u0011\u000b\u0014\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i\u0003I\u0019\b.\u001e;e_^t\u0017J\\5uS\u0006$X\r\u001a\u0011\u0002!MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0017!E:ikR$wn\u001e8D_6\u0004H.\u001a;fA\u0005I\u0011n]*uCJ$X\rZ\u0001\u000eSN\u001cF/\u0019:uK\u0012|F%Z9\u0015\u0005a[\u0006CA Z\u0013\tQFG\u0001\u0003V]&$\bb\u0002/\f\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0014AC5t'R\f'\u000f^3eA!\u0012Ab\u0018\t\u0003\u007f\u0001L!!\u0019\u001b\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u00021\u0006\u0011\u0012n]*ikR$wn\u001e8D_6\u0004H.\u001a;f\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000eF\u0001?\u00035\tw/Y5u'\",H\u000fZ8x]\u0006)\u0001/Y;tKR\u0019\u0001L[8\t\u000b-\f\u0002\u0019\u00017\u0002\u000fQLW.Z8viB\u0011q(\\\u0005\u0003]R\u0012A\u0001T8oO\")\u0001/\u0005a\u0001c\u0006!QO\\5u!\tY%/\u0003\u0002t\u0019\nAA+[7f+:LG/\u0001\u0004e_^{'o[\u0001\u0004eVt\u0017!C5t%Vtg.\u001b8h\u0003I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005%22C\u0001\f{!\ty40\u0003\u0002}i\t1\u0011I\\=SK\u001a$\u0012\u0001_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005!f\u0001 \u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010Q\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class ShutdownableThread
extends Thread
implements Logging {
    private final String name;
    private final boolean isInterruptible;
    private final CountDownLatch shutdownInitiated;
    private final CountDownLatch shutdownComplete;
    private volatile boolean isStarted;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ShutdownableThread$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ShutdownableThread shutdownableThread = this;
        synchronized (shutdownableThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public boolean isInterruptible() {
        return this.isInterruptible;
    }

    private CountDownLatch shutdownInitiated() {
        return this.shutdownInitiated;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private boolean isStarted() {
        return this.isStarted;
    }

    private void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void shutdown() {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete().getCount() == 0L;
    }

    public synchronized boolean initiateShutdown() {
        boolean bl;
        if (this.isRunning()) {
            this.info((Function0<String> & java.io.Serializable & Serializable)() -> "Shutting down");
            this.shutdownInitiated().countDown();
            if (this.isInterruptible()) {
                this.interrupt();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void awaitShutdown() {
        if (this.shutdownInitiated().getCount() != 0L) {
            throw new IllegalStateException("initiateShutdown() was not called before awaitShutdown()");
        }
        if (this.isStarted()) {
            this.shutdownComplete().await();
        }
        this.info((Function0<String> & java.io.Serializable & Serializable)() -> "Shutdown completed");
    }

    public void pause(long timeout, TimeUnit unit) {
        block0: {
            if (!this.shutdownInitiated().await(timeout, unit)) break block0;
            this.trace((Function0<String> & java.io.Serializable & Serializable)() -> "shutdownInitiated latch count reached zero. Shutdown called.");
        }
    }

    public abstract void doWork();

    @Override
    public void run() {
        this.isStarted_$eq(true);
        this.info((Function0<String> & java.io.Serializable & Serializable)() -> "Starting");
        try {
            try {
                while (this.isRunning()) {
                    this.doWork();
                }
            }
            catch (FatalExitError e) {
                this.shutdownInitiated().countDown();
                this.shutdownComplete().countDown();
                this.info((Function0<String> & java.io.Serializable & Serializable)() -> "Stopped");
                throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
            }
            catch (Throwable e) {
                if (this.isRunning()) {
                    this.error((Function0<String> & java.io.Serializable & Serializable)() -> "Error due to", (Function0<Throwable> & java.io.Serializable & Serializable)() -> e);
                }
            }
        }
        finally {
            this.shutdownComplete().countDown();
        }
        this.info((Function0<String> & java.io.Serializable & Serializable)() -> "Stopped");
    }

    public boolean isRunning() {
        return this.shutdownInitiated().getCount() != 0L;
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        this.name = name;
        this.isInterruptible = isInterruptible;
        super(name);
        Logging.$init$(this);
        this.setDaemon(false);
        this.logIdent_$eq(new StringBuilder(4).append("[").append(name).append("]: ").toString());
        this.shutdownInitiated = new CountDownLatch(1);
        this.shutdownComplete = new CountDownLatch(1);
        this.isStarted = false;
    }
}

