/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.ElectPreferredLeadersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class ElectPreferredLeadersResponse
extends AbstractResponse {
    private final ElectPreferredLeadersResponseData data;

    public ElectPreferredLeadersResponse(ElectPreferredLeadersResponseData data) {
        this.data = data;
    }

    public ElectPreferredLeadersResponse(Struct struct, short version) {
        this.data = new ElectPreferredLeadersResponseData(struct, version);
    }

    public ElectPreferredLeadersResponse(Struct struct) {
        short latestVersion = (short)(ElectPreferredLeadersResponseData.SCHEMAS.length - 1);
        this.data = new ElectPreferredLeadersResponseData(struct, latestVersion);
    }

    public ElectPreferredLeadersResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (ElectPreferredLeadersResponseData.ReplicaElectionResult result2 : this.data.replicaElectionResults()) {
            for (ElectPreferredLeadersResponseData.PartitionResult partitionResult : result2.partitionResult()) {
                Errors error = Errors.forCode(partitionResult.errorCode());
                counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
            }
        }
        return counts;
    }

    public static ElectPreferredLeadersResponse parse(ByteBuffer buffer, short version) {
        return new ElectPreferredLeadersResponse(ApiKeys.ELECT_PREFERRED_LEADERS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }
}

