/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class IncrementalAlterConfigsResponse
extends AbstractResponse {
    private final IncrementalAlterConfigsResponseData data;

    public static IncrementalAlterConfigsResponseData toResponseData(int requestThrottleMs, Map<ConfigResource, ApiError> results) {
        IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
        responseData.setThrottleTimeMs(requestThrottleMs);
        for (Map.Entry<ConfigResource, ApiError> entry : results.entrySet()) {
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResult().setResourceName(entry.getKey().name()).setResourceType(entry.getKey().type().id()).setErrorCode(entry.getValue().error().code()).setErrorMessage(entry.getValue().message()));
        }
        return responseData;
    }

    public static Map<ConfigResource, ApiError> fromResponseData(IncrementalAlterConfigsResponseData data) {
        HashMap<ConfigResource, ApiError> map = new HashMap<ConfigResource, ApiError>();
        for (IncrementalAlterConfigsResponseData.AlterConfigsResourceResult result2 : data.responses()) {
            map.put(new ConfigResource(ConfigResource.Type.forId(result2.resourceType()), result2.resourceName()), new ApiError(Errors.forCode(result2.errorCode()), result2.errorMessage()));
        }
        return map;
    }

    public IncrementalAlterConfigsResponse(IncrementalAlterConfigsResponseData data) {
        this.data = data;
    }

    public IncrementalAlterConfigsResponse(Struct struct, short version) {
        this.data = new IncrementalAlterConfigsResponseData(struct, version);
    }

    public IncrementalAlterConfigsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (IncrementalAlterConfigsResponseData.AlterConfigsResourceResult result2 : this.data.responses()) {
            Errors error = Errors.forCode(result2.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 0;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public static IncrementalAlterConfigsResponse parse(ByteBuffer buffer, short version) {
        return new IncrementalAlterConfigsResponse(ApiKeys.INCREMENTAL_ALTER_CONFIGS.responseSchema(version).read(buffer), version);
    }
}

