/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ResponseHeader;

public class RequestHeader
extends AbstractRequestResponse {
    private static final String API_KEY_FIELD_NAME = "api_key";
    private static final String API_VERSION_FIELD_NAME = "api_version";
    private static final String CLIENT_ID_FIELD_NAME = "client_id";
    private static final String CORRELATION_ID_FIELD_NAME = "correlation_id";
    public static final Schema SCHEMA = new Schema(new Field("api_key", Type.INT16, "The id of the request type."), new Field("api_version", Type.INT16, "The version of the API."), new Field("correlation_id", Type.INT32, "A user-supplied integer value that will be passed back with the response"), new Field("client_id", Type.NULLABLE_STRING, "A user specified identifier for the client making the request.", ""));
    private static final Schema CONTROLLED_SHUTDOWN_V0_SCHEMA = new Schema(new Field("api_key", Type.INT16, "The id of the request type."), new Field("api_version", Type.INT16, "The version of the API."), new Field("correlation_id", Type.INT32, "A user-supplied integer value that will be passed back with the response"));
    private final ApiKeys apiKey;
    private final short apiVersion;
    private final String clientId;
    private final int correlationId;

    public RequestHeader(Struct struct) {
        short apiKey = struct.getShort(API_KEY_FIELD_NAME);
        if (!ApiKeys.hasId(apiKey)) {
            throw new InvalidRequestException("Unknown API key " + apiKey);
        }
        this.apiKey = ApiKeys.forId(apiKey);
        this.apiVersion = struct.getShort(API_VERSION_FIELD_NAME);
        this.clientId = struct.hasField(CLIENT_ID_FIELD_NAME) ? struct.getString(CLIENT_ID_FIELD_NAME) : "";
        this.correlationId = struct.getInt(CORRELATION_ID_FIELD_NAME);
    }

    public RequestHeader(ApiKeys apiKey, short version, String clientId, int correlation) {
        this.apiKey = Objects.requireNonNull(apiKey);
        this.apiVersion = version;
        this.clientId = clientId;
        this.correlationId = correlation;
    }

    public Struct toStruct() {
        Schema schema = RequestHeader.schema(this.apiKey.id, this.apiVersion);
        Struct struct = new Struct(schema);
        struct.set(API_KEY_FIELD_NAME, (Object)this.apiKey.id);
        struct.set(API_VERSION_FIELD_NAME, (Object)this.apiVersion);
        if (struct.hasField(CLIENT_ID_FIELD_NAME)) {
            struct.set(CLIENT_ID_FIELD_NAME, (Object)this.clientId);
        }
        struct.set(CORRELATION_ID_FIELD_NAME, (Object)this.correlationId);
        return struct;
    }

    public ApiKeys apiKey() {
        return this.apiKey;
    }

    public short apiVersion() {
        return this.apiVersion;
    }

    public String clientId() {
        return this.clientId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public ResponseHeader toResponseHeader() {
        return new ResponseHeader(this.correlationId);
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        try {
            short apiKey = buffer.getShort();
            short apiVersion = buffer.getShort();
            Schema schema = RequestHeader.schema(apiKey, apiVersion);
            buffer.rewind();
            return new RequestHeader(schema.read(buffer));
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error parsing request header. Our best guess of the apiKey is: " + buffer.getShort(0), ex);
        }
    }

    public String toString() {
        return "RequestHeader(apiKey=" + (Object)((Object)this.apiKey) + ", apiVersion=" + this.apiVersion + ", clientId=" + this.clientId + ", correlationId=" + this.correlationId + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHeader that = (RequestHeader)o;
        return this.apiKey == that.apiKey && this.apiVersion == that.apiVersion && this.correlationId == that.correlationId && Objects.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        int result2 = this.apiKey.hashCode();
        result2 = 31 * result2 + this.apiVersion;
        result2 = 31 * result2 + (this.clientId != null ? this.clientId.hashCode() : 0);
        result2 = 31 * result2 + this.correlationId;
        return result2;
    }

    private static Schema schema(short apiKey, short version) {
        if (apiKey == ApiKeys.CONTROLLED_SHUTDOWN.id && version == 0) {
            return CONTROLLED_SHUTDOWN_V0_SCHEMA;
        }
        return SCHEMA;
    }
}

