/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.tenant.config;

import com.chinamcloud.bigdata.tenant.config.ConfigBean;
import com.chinamcloud.bigdata.tenant.config.HMACSHA1;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import sun.misc.BASE64Encoder;

public class ConstructSignParameter {
    public static Map<String, String> getSignParamter(Map<String, String> parameter) throws UnsupportedEncodingException, EncoderException, InvalidKeyException, NoSuchAlgorithmException {
        if (!ConfigBean.isTrue().booleanValue()) {
            return null;
        }
        String accessKeyId = ConfigBean.ACCESSKEYID;
        String accessKeySecret = ConfigBean.ACCESSKEYSECRET;
        String serviceKey = ConfigBean.SERVICEKEY;
        String signatureNonce = UUID.randomUUID().toString().replace("-", "");
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AccessKeyId", accessKeyId);
        map.put("AccessKeySecret", accessKeySecret);
        map.put("ServiceKey", serviceKey);
        map.put("SignatureMethod", "HMAC-SHA1");
        map.put("Timestamp", timestamp);
        map.put("SignatureNonce", signatureNonce);
        if (parameter != null) {
            parameter.putAll(map);
        } else {
            parameter = map;
        }
        List<Object> list = Arrays.asList(parameter.keySet().toArray());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i).toString();
            sb.append(new URLCodec().encode(key, "utf-8"));
            sb.append("=");
            sb.append(new URLCodec().encode(parameter.get(key)));
            if (i == list.size() - 1) continue;
            sb.append("&");
        }
        String parameterStr = "GET&%2F&" + new URLCodec().encode(sb.toString());
        String signature = new URLCodec().encode(new BASE64Encoder().encode(HMACSHA1.getSignatureToByte(parameterStr, accessKeySecret + "&")), "UTF-8");
        parameter.put("Signature", signature);
        return parameter;
    }
}

