/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.tenant.Utils;

import com.chinamcloud.bigdata.common.http.utils.HttpRequestSetter;
import com.chinamcloud.bigdata.common.http.utils.HttpUtils;
import com.chinamcloud.bigdata.tenant.config.AbstractAuthProvider;
import com.chinamcloud.bigdata.tenant.config.AuthProvider;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;

public class FrameRequest {
    private static final String CONF_PATH = "config/tenant.properties";
    private AbstractAuthProvider authProvider = null;

    private FrameRequest(AbstractAuthProvider authProvider) {
        if (authProvider == null) {
            throw new RuntimeException("auth provider must be not null");
        }
        authProvider.validate();
        this.authProvider = authProvider;
    }

    public static FrameRequest defaultInstance() {
        AuthProvider provider = new AuthProvider();
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(AbstractAuthProvider.class.getClassLoader().getResourceAsStream(CONF_PATH), "UTF-8"));
        }
        catch (Exception e) {
            System.exit(0);
        }
        String secretKey = properties.getProperty("secretKey");
        String accessKeyId = properties.getProperty("accessKeyId");
        String accessKeySecret = properties.getProperty("accessKeySecret");
        String authKey = properties.getProperty("authKey");
        String serviceKey = properties.getProperty("serviceKey");
        String host = properties.getProperty("host");
        if (StringUtils.isNotBlank((CharSequence)secretKey)) {
            provider.setSecretKey(secretKey);
        }
        if (StringUtils.isNotBlank((CharSequence)accessKeyId)) {
            provider.setAccessKeyId(accessKeyId);
        }
        if (StringUtils.isNotBlank((CharSequence)accessKeySecret)) {
            provider.setAccessKeySecret(accessKeySecret);
        }
        if (StringUtils.isNotBlank((CharSequence)authKey)) {
            provider.setAuthKey(authKey);
        }
        if (StringUtils.isNotBlank((CharSequence)serviceKey)) {
            provider.setServiceKey(serviceKey);
        }
        if (StringUtils.isNotBlank((CharSequence)host)) {
            provider.setHost(host);
        }
        return new FrameRequest(provider);
    }

    public static FrameRequest newInstance(AbstractAuthProvider provider) {
        return new FrameRequest(provider);
    }

    public String requestPost(String path, String contentBody) throws UnsupportedEncodingException, EncoderException {
        String url = this.authProvider.buildRequestUrl(path, new Map[0]);
        String result = HttpUtils.executePost((String)url, (String)contentBody, (HttpRequestSetter[])new HttpRequestSetter[]{new HttpRequestSetter(){

            public void process(HttpRequestBase httpRequestBase) {
                httpRequestBase.setHeader("Content-Type", "application/json");
            }
        }});
        return result;
    }

    public String requestGet(String path, Map<String, String> params) throws UnsupportedEncodingException, EncoderException {
        String url = this.authProvider.buildRequestUrl(path, params);
        String result = HttpUtils.executeGet((String)url, null, (HttpRequestSetter[])new HttpRequestSetter[0]);
        return result;
    }
}

