/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.tenant.config;

import com.chinamcloud.bigdata.tenant.Utils.HMACSHA1;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import sun.misc.BASE64Encoder;

public abstract class AbstractAuthProvider {
    private String secretKey;
    private String accessKeyId;
    private String accessKeySecret;
    private String authKey;
    private String serviceKey;
    private String host;
    private String signatureVersion = "1.0";
    private String signatureMethod = "HMAC-SHA1";

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(String signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.host) || StringUtils.isBlank((CharSequence)this.accessKeyId)) {
            throw new RuntimeException("parameter error!");
        }
    }

    public String buildRequestUrl(String path, Map<String, String> ... params) throws UnsupportedEncodingException, EncoderException {
        Map<String, String> signParamter = this.getSignParamter(params);
        StringBuilder sb = new StringBuilder();
        for (String key : signParamter.keySet()) {
            sb.append(key);
            sb.append("=");
            sb.append(signParamter.get(key));
            sb.append("&");
        }
        String r = sb.toString();
        String url = (this.host.endsWith("/") ? this.host : this.host + "/") + (path.endsWith("?") ? path : path + "?");
        String requestURL = url + r.substring(0, r.lastIndexOf("&"));
        return requestURL;
    }

    private Map<String, String> getSignParamter(Map<String, String> ... params) throws UnsupportedEncodingException, EncoderException {
        String signatureNonce = UUID.randomUUID().toString().replace("-", "");
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("AccessKeyId", this.accessKeyId);
        if (StringUtils.isNotBlank((CharSequence)this.accessKeySecret)) {
            map.put("AccessKeySecret", this.accessKeySecret);
        }
        if (StringUtils.isNotBlank((CharSequence)this.serviceKey)) {
            map.put("ServiceKey", this.serviceKey);
        }
        map.put("SignatureVersion", this.signatureVersion);
        map.put("SignatureMethod", this.signatureMethod);
        if (StringUtils.isNotBlank((CharSequence)this.authKey)) {
            map.put("auth_key", this.authKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.secretKey)) {
            map.put("SecretKey", this.secretKey);
        }
        map.put("Timestamp", timestamp);
        map.put("SignatureNonce", signatureNonce);
        for (Map<String, String> param : params) {
            if (param == null) continue;
            map.putAll(param);
        }
        LinkedList list = new LinkedList(map.keySet());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String key = ((String)list.get(i)).toString();
            sb.append(new URLCodec().encode(key, "utf-8"));
            sb.append("=");
            sb.append(new URLCodec().encode((String)map.get(key)));
            if (i == list.size() - 1) continue;
            sb.append("&");
        }
        String parameterStr = "GET&%2F&" + new URLCodec().encode(sb.toString());
        try {
            String signature = new URLCodec().encode(new BASE64Encoder().encode(HMACSHA1.getSignatureToByte(parameterStr, this.accessKeySecret + "&")), "UTF-8");
            map.put("Signature", signature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

