/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.tenant.service;

import com.chinamcloud.bigdata.tenant.Utils.FrameRequest;
import com.chinamcloud.bigdata.tenant.bean.parameter.BaseParameter;
import com.chinamcloud.bigdata.tenant.bean.parameter.GroupInfoParameter;
import com.chinamcloud.bigdata.tenant.bean.parameter.LoginAuthParameter;
import com.chinamcloud.bigdata.tenant.bean.parameter.SubGroupListParameter;
import com.chinamcloud.bigdata.tenant.bean.result.GroupInfo;
import com.chinamcloud.bigdata.tenant.bean.result.LoginData;
import com.chinamcloud.bigdata.tenant.bean.result.ResultDataMedia;
import com.chinamcloud.bigdata.tenant.config.AuthProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang3.StringUtils;

public class Tenant {
    private static ObjectMapper mapper = new ObjectMapper();
    private FrameRequest frameRequest;

    public Tenant() {
    }

    public Tenant(FrameRequest frameRequest) {
        this.frameRequest = frameRequest;
    }

    public List<GroupInfo> getSubGroupList(SubGroupListParameter subGroupListParameter) {
        String json = Tenant.getJson(subGroupListParameter);
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new RuntimeException("Json cannot be empty");
        }
        if (this.frameRequest == null) {
            throw new RuntimeException("frameRequest cannot be empty");
        }
        String result = "";
        try {
            result = this.frameRequest.requestPost(subGroupListParameter.getPath(), json);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        result = Tenant.JsonValidate(result);
        ResultDataMedia resultDataMedia = null;
        try {
            resultDataMedia = (ResultDataMedia)mapper.readValue(result, (TypeReference)new TypeReference<ResultDataMedia<List<GroupInfo>>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (List)resultDataMedia.getData();
    }

    public LoginData getLoginAuth(LoginAuthParameter loginAuthParameter) {
        String json = Tenant.getJson(loginAuthParameter);
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new RuntimeException("Json cannot be empty");
        }
        if (this.frameRequest == null) {
            throw new RuntimeException("frameRequest cannot be empty");
        }
        String result = "";
        try {
            result = this.frameRequest.requestPost(loginAuthParameter.getPath(), json);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        result = Tenant.JsonValidate(result);
        ResultDataMedia resultDataMedia = null;
        try {
            resultDataMedia = (ResultDataMedia)mapper.readValue(result, (TypeReference)new TypeReference<ResultDataMedia<LoginData>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (LoginData)resultDataMedia.getData();
    }

    public GroupInfo getGroupInfo(GroupInfoParameter groupInfoParameter) {
        String result = "";
        try {
            result = this.frameRequest.requestGet(groupInfoParameter.getPath(), groupInfoParameter.getMap());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
        result = Tenant.JsonValidate(result);
        ResultDataMedia resultDataMedia = null;
        try {
            resultDataMedia = (ResultDataMedia)mapper.readValue(result, (TypeReference)new TypeReference<ResultDataMedia<GroupInfo>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (GroupInfo)resultDataMedia.getData();
    }

    public static String getJson(BaseParameter baseParameter) {
        if (baseParameter.validate().booleanValue()) {
            throw new RuntimeException("path or group_id cannot be empty");
        }
        String json = "";
        try {
            json = mapper.writeValueAsString(baseParameter.getMap());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String JsonValidate(String result) {
        if (result.contains("\"data\":[]") || !result.contains("\"code\":10000")) {
            ResultDataMedia resultDataMedia = null;
            try {
                resultDataMedia = (ResultDataMedia)mapper.readValue(result, ResultDataMedia.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new RuntimeException(resultDataMedia == null ? "result error" : resultDataMedia.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            result = result.replace("\"group_conf\":[]", "\"group_conf\":{}");
        }
        return result;
    }

    public static void testgetSubGroupList() {
        SubGroupListParameter subGroupListParameter = new SubGroupListParameter();
        subGroupListParameter.setGroup_id("c10e87f39873512a16727e17f57456a5");
        subGroupListParameter.setPath("/cmc/group/get-sub-group-list");
        Tenant tenant = new Tenant(FrameRequest.defaultInstance());
        List<GroupInfo> subGroupList = tenant.getSubGroupList(subGroupListParameter);
        System.out.println(subGroupList);
    }

    public static void testgetLoginAuth() {
        LoginAuthParameter loginAuthParameter = new LoginAuthParameter();
        loginAuthParameter.setLogin_id("82d6d5393ca39e428924540f7452ebea");
        loginAuthParameter.setLogin_tid("bf079ea88783271d89b1780f74b483f2");
        loginAuthParameter.setPath("cmc/login/get-login-auth");
        loginAuthParameter.setAuth_key("");
        AuthProvider authProvider = new AuthProvider();
        authProvider.setAccessKeyId("AsdZcqfGvXcIfDeF");
        authProvider.setAccessKeySecret("FShvfe4Cdd4qrF7mfHyP8ogbk5pE7wzT");
        authProvider.setServiceKey("yqdsj");
        authProvider.setHost("https://cmckong.wjtest.chinamcloud.cn");
        Tenant tenant = new Tenant(FrameRequest.newInstance(authProvider));
        LoginData loginAuth = tenant.getLoginAuth(loginAuthParameter);
        System.out.println(loginAuth);
    }

    public static void testgetGroupInfo() {
        GroupInfoParameter groupInfoParameter = new GroupInfoParameter();
        groupInfoParameter.setGroup_id("c10e87f39873512a16727e17f57456a5");
        groupInfoParameter.setPath("cmc/group/get-group-info");
        AuthProvider authProvider = new AuthProvider();
        authProvider.setAccessKeyId("I6iwZ5bBaR1Drhq2");
        authProvider.setAccessKeySecret("WFl6Iq4rxPAV9XiEtG21KdjnSs3kzgQ7");
        authProvider.setServiceKey("cbxg");
        authProvider.setHost("https://cmckong.flydev.chinamcloud.cn");
        Tenant tenant = new Tenant(FrameRequest.newInstance(authProvider));
        GroupInfo groupInfo = tenant.getGroupInfo(groupInfoParameter);
        System.out.println(groupInfo);
    }

    public static void main(String[] args) {
        Tenant.testgetGroupInfo();
    }
}

