/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.xxljob.executorstart;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication(scanBasePackages={"com.chinamcloud.bigdata.xxljob", "com.xxl.job"})
public class App {
    private ReentrantLock lock = new ReentrantLock();
    private Condition stop = this.lock.newCondition();

    public static void main(String[] args) {
        SpringApplication.run(App.class, (String[])args);
        new App().addShutDownHook();
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new ShutDownThread());
        try {
            this.lock.lock();
            this.stop.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    class ShutDownThread
    extends Thread {
        ShutDownThread() {
        }

        @Override
        public void run() {
            try {
                App.this.lock.lock();
                App.this.stop.signal();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                App.this.lock.unlock();
            }
        }
    }
}

