/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import com.chinamcloud.common.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class FileUtil {
    public static boolean writeText(String fileName, String content) {
        return FileUtil.writeText(fileName, content, "UTF-8");
    }

    public static boolean writeText(String fileName, String content, String encoding) {
        return FileUtil.writeText(fileName, content, encoding, false);
    }

    public static boolean writeText(String fileName, String content, String encoding, boolean bomFlag) {
        try {
            byte[] bs = content.getBytes(encoding);
            if (encoding.equalsIgnoreCase("UTF-8") && bomFlag) {
                bs = ArrayUtils.addAll((byte[])StringUtil.BOM, (byte[])bs);
            }
            FileUtil.writeByte(fileName, bs);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static byte[] readByte(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            byte[] r = new byte[fis.available()];
            fis.read(r);
            fis.close();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readByte(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            byte[] r = FileUtil.readByte(fis);
            fis.close();
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readByte(InputStream is) {
        try {
            byte[] r = new byte[is.available()];
            is.read(r);
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean writeByte(String fileName, byte[] b) {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fileName));
            fos.write(b);
            fos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeByte(File f, byte[] b) {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));
            fos.write(b);
            fos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String readText(File f) {
        return FileUtil.readText(f, "UTF-8");
    }

    public static String readText(File f, String encoding) {
        try {
            FileInputStream is = new FileInputStream(f);
            String str = FileUtil.readText(is, encoding);
            ((InputStream)is).close();
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(InputStream is, String encoding) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readText(String fileName) {
        return FileUtil.readText(fileName, "UTF-8");
    }

    public static String readText(String fileName, String encoding) {
        try {
            String line;
            FileInputStream is = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, encoding));
            StringBuffer sb = new StringBuffer();
            int c = br.read();
            if (!encoding.equalsIgnoreCase("UTF-8") || c != 65279) {
                sb.append((char)c);
            }
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            ((InputStream)is).close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readURLText(String urlPath) {
        return FileUtil.readURLText(urlPath, "UTF-8");
    }

    public static String readURLText(String urlPath, String encoding) {
        try {
            String line;
            URL url = new URL(urlPath);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(String path) {
        File file = new File(path);
        return FileUtil.delete(file);
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        return FileUtil.deleteDir(file);
    }

    private static boolean deleteDir(File dir) {
        try {
            return FileUtil.deleteFromDir(dir) && dir.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean mkdir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return true;
    }

    public static boolean deleteEx(String fileName) {
        int index2;
        int index1 = fileName.lastIndexOf("\\");
        index1 = index1 > (index2 = fileName.lastIndexOf("/")) ? index1 : index2;
        String path = fileName.substring(0, index1);
        String name = fileName.substring(index1 + 1);
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!Pattern.matches(name, files[i].getName())) continue;
                files[i].delete();
            }
            return true;
        }
        return false;
    }

    public static boolean deleteFromDir(String dirPath) {
        File file = new File(dirPath);
        return FileUtil.deleteFromDir(file);
    }

    public static boolean deleteFromDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] tempList = dir.listFiles();
        for (int i = 0; i < tempList.length; ++i) {
            if (FileUtil.delete(tempList[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean copy(String oldPath, String newPath, FileFilter filter) {
        File oldFile = new File(oldPath);
        File[] oldFiles = oldFile.listFiles(filter);
        boolean flag = true;
        if (oldFiles != null) {
            for (int i = 0; i < oldFiles.length; ++i) {
                if (FileUtil.copy(oldFiles[i], newPath + "/" + oldFiles[i].getName())) continue;
                flag = false;
            }
        }
        return flag;
    }

    public static boolean copy(String oldPath, String newPath) {
        File oldFile = new File(oldPath);
        return FileUtil.copy(oldFile, newPath);
    }

    public static boolean copy(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            return false;
        }
        if (oldFile.isFile()) {
            return FileUtil.copyFile(oldFile, newPath);
        }
        return FileUtil.copyDir(oldFile, newPath);
    }

    private static boolean copyFile(File oldFile, String newPath) {
        if (!oldFile.exists()) {
            return false;
        }
        if (!oldFile.isFile()) {
            return false;
        }
        try {
            int byteread = 0;
            FileInputStream inStream = new FileInputStream(oldFile);
            FileOutputStream fs = new FileOutputStream(newPath);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.close();
            ((InputStream)inStream).close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean copyDir(File oldDir, String newPath) {
        if (!oldDir.exists()) {
            return false;
        }
        if (!oldDir.isDirectory()) {
            return false;
        }
        try {
            new File(newPath).mkdirs();
            File[] files = oldDir.listFiles();
            File temp = null;
            for (int i = 0; i < files.length; ++i) {
                temp = files[i];
                if (!(temp.isFile() ? !FileUtil.copyFile(temp, newPath + "/" + temp.getName()) : temp.isDirectory() && !FileUtil.copyDir(temp, newPath + "/" + temp.getName()))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean move(String oldPath, String newPath) {
        return FileUtil.copy(oldPath, newPath) && FileUtil.delete(oldPath);
    }

    public static boolean move(File oldFile, String newPath) {
        return FileUtil.copy(oldFile, newPath) && FileUtil.delete(oldFile);
    }

    public static void serialize(Serializable obj, String fileName) {
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(obj);
            s.flush();
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize(Serializable obj) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(b);
            s.writeObject(obj);
            s.flush();
            s.close();
            return b.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object unserialize(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s = new ObjectInputStream(in);
            Object o = s.readObject();
            s.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object unserialize(byte[] bs) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bs);
            ObjectInputStream s = new ObjectInputStream(in);
            Object o = s.readObject();
            s.close();
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void uploadFile(File sourceFile, File targetFile) {
        try {
            File parentFile = new File(targetFile.getParent());
            parentFile.mkdirs();
            FileInputStream is = new FileInputStream(sourceFile);
            FileOutputStream os = new FileOutputStream(targetFile);
            int len = 0;
            byte[] buffer = new byte[500];
            while (-1 != (len = ((InputStream)is).read(buffer))) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileDataByBR(String path) {
        String xml = "";
        FileInputStream fs = null;
        InputStreamReader is = null;
        BufferedReader br = null;
        try {
            fs = new FileInputStream(path);
            is = new InputStreamReader((InputStream)fs, "UTF-8");
            br = new BufferedReader(is);
            String str = "";
            xml = "";
            while ((str = br.readLine()) != null) {
                xml = xml + str + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fs.close();
                is.close();
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xml;
    }
}

