/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import java.math.BigDecimal;
import java.util.Random;
import java.util.regex.Pattern;

public class NumberUtil {
    private static Pattern numberPatter = Pattern.compile("^[\\d\\.E\\,]*$");
    private static long Seed = System.currentTimeMillis();
    private static Random rand = new Random();

    public static boolean isNumber(String str) {
        return numberPatter.matcher(str).find();
    }

    public static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        return NumberUtil.isInt(str);
    }

    public static boolean isLong(String str) {
        boolean flag = false;
        try {
            Long.parseLong(str);
            flag = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static double round(double v, int scale) {
        if ("NaN".equals(String.valueOf(v))) {
            v = 0.0;
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static int getRandomInt(int max) {
        rand.setSeed(Seed);
        ++Seed;
        return rand.nextInt(max);
    }

    public static int toInt(byte[] bs) {
        return NumberUtil.toInt(bs, 0);
    }

    public static int toInt(byte[] bs, int start) {
        int i = 0;
        i += (bs[start] & 0xFF) << 24;
        i += (bs[start + 1] & 0xFF) << 16;
        i += (bs[start + 2] & 0xFF) << 8;
        return i += bs[start + 3] & 0xFF;
    }

    public static byte[] toBytes(int i) {
        byte[] bs = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)(i & 0xFF)};
        return bs;
    }

    public static void toBytes(int i, byte[] bs, int start) {
        bs[start] = (byte)(i >> 24);
        bs[start + 1] = (byte)(i >> 16);
        bs[start + 2] = (byte)(i >> 8);
        bs[start + 3] = (byte)(i & 0xFF);
    }

    public static short toShort(byte[] bs) {
        return NumberUtil.toShort(bs, 0);
    }

    public static short toShort(byte[] bs, int start) {
        short i = 0;
        i = (short)(i + ((bs[start + 0] & 0xFF) << 8));
        i = (short)(i + (bs[start + 1] & 0xFF));
        return i;
    }

    public static byte[] toBytes(short i) {
        byte[] bs = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
        return bs;
    }

    public static void toBytes(short i, byte[] bs, int start) {
        bs[start + 0] = (byte)(i >> 8);
        bs[start + 1] = (byte)(i & 0xFF);
    }

    public static byte[] toBytes(long i) {
        byte[] bs = new byte[]{(byte)(i >> 56), (byte)(i >> 48), (byte)(i >> 40), (byte)(i >> 32), (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)(i & 0xFFL)};
        return bs;
    }

    public static void toBytes(long l, byte[] bs, int start) {
        byte[] arr = NumberUtil.toBytes(l);
        for (int i = 0; i < 8; ++i) {
            bs[start + i] = arr[i];
        }
    }

    public static long toLong(byte[] bs) {
        return NumberUtil.toLong(bs, 0);
    }

    public static long toLong(byte[] bs, int index) {
        return ((long)bs[index] & 0xFFL) << 56 | ((long)bs[index + 1] & 0xFFL) << 48 | ((long)bs[index + 2] & 0xFFL) << 40 | ((long)bs[index + 3] & 0xFFL) << 32 | ((long)bs[index + 4] & 0xFFL) << 24 | ((long)bs[index + 5] & 0xFFL) << 16 | ((long)bs[index + 6] & 0xFFL) << 8 | ((long)bs[index + 7] & 0xFFL) << 0;
    }
}

