/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import java.text.NumberFormat;
import java.util.Locale;

public class Similarity {
    public static void main(String[] args) {
        String strA = "\u8d56\u6c49";
        String strB = "\u8d56\u6c49\u7684\u5e78\u798f\u6307\u6570";
        double result = Similarity.SimilarDegree(strA, strB);
        if (result >= 0.7) {
            System.out.println("\u76f8\u4f3c\u5ea6\u5f88\u9ad8\uff01" + Similarity.similarityResult(result));
        } else {
            System.out.println("\u76f8\u4f3c\u5ea6\u4e0d\u9ad8" + Similarity.similarityResult(result));
        }
    }

    public static String similarityResult(double resule) {
        return NumberFormat.getPercentInstance(new Locale("en ", "US ")).format(resule);
    }

    public static double SimilarDegree(String strA, String strB) {
        try {
            if (strA.length() < strB.length()) {
                String str = strB;
                strB = strA;
                strA = str;
            }
            String newStrA = Similarity.removeSign(strA);
            String newStrB = Similarity.removeSign(strB);
            int temp = Math.max(newStrA.length(), newStrB.length());
            int temp2 = Similarity.longestCommonSubstring(newStrA, newStrB).length();
            return (double)temp2 * 1.0 / (double)temp;
        }
        catch (Exception e) {
            System.out.println("\u5b57\u7b26\u4e32\u76f8\u4f3c\u5ea6\u6bd4\u8f83\u51fa\u73b0\u5f02\u5e38");
            System.out.println("\u5b57\u7b26\u4e32A==========\u300b" + strA);
            System.out.println("\u5b57\u7b26\u4e32B==========\u300b" + strB);
            e.printStackTrace();
            return 0.0;
        }
    }

    private static String removeSign(String str) {
        StringBuffer sb = new StringBuffer();
        for (char item : str.toCharArray()) {
            if (!Similarity.charReg(item)) continue;
            sb.append(item);
        }
        return sb.toString();
    }

    private static boolean charReg(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fa5' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int m = chars_strA.length;
        int n = chars_strB.length;
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[n] == matrix[n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = chars_strA[m - 1];
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }
}

