/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import com.chinamcloud.common.util.Similarity;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class StringUtil {
    public static final byte[] BOM = new byte[]{-17, -69, -65};

    public static String randomString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String strNullFormat(String str) {
        if (str == null) {
            return "";
        }
        return str.toString();
    }

    public static Long longNullFormat(Long lo) {
        if (lo == null) {
            return 0L;
        }
        return lo;
    }

    public static Integer intNullFormat(Integer in) {
        if (in == null) {
            return 0;
        }
        return in;
    }

    public static boolean isNum(String str) {
        return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static double similarDegree(String strA, String strB) {
        return Similarity.SimilarDegree(strA, strB);
    }

    public static Long getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTimeInMillis();
    }

    public static Long getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTimeInMillis();
    }

    public static String parseNumberToEn(String str) {
        String newStr = "";
        try {
            if (StringUtil.isNotEmpty(str)) {
                String chars = "abcdefghijklmnopqrstuvwxyz";
                for (int i = 0; i < str.length(); ++i) {
                    newStr = str.charAt(i) <= 'Z' && str.charAt(i) >= 'A' || str.charAt(i) <= 'z' && str.charAt(i) >= 'a' ? newStr + str.charAt(i) : newStr + chars.charAt((int)(Math.random() * 26.0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newStr;
    }

    public static boolean hasAllZimu(String str) {
        Boolean flag = true;
        if (StringUtil.isNotEmpty(str)) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) <= 'Z' && str.charAt(i) >= 'A' || str.charAt(i) <= 'z' && str.charAt(i) >= 'a') continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public static String replaceEx(String str, String subStr, String reStr) {
        if (str == null) {
            return null;
        }
        if (subStr == null || subStr.equals("") || subStr.length() > str.length() || reStr == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        String tmp = str;
        int index = -1;
        while ((index = tmp.indexOf(subStr)) >= 0) {
            sb.append(tmp.substring(0, index));
            sb.append(reStr);
            tmp = tmp.substring(index + subStr.length());
        }
        sb.append(tmp);
        return sb.toString();
    }

    public static String dateFormat(Long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                System.out.println(ex);
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String replaceAllToSlant(String str) {
        if (StringUtil.isNotEmpty(str)) {
            str = str.replaceAll("\\\\", "/");
            str = str.replaceAll("/+", "/");
        }
        return str;
    }

    public static String replaceAllToBack_Slant(String str) {
        if (StringUtil.isNotEmpty(str)) {
            str = str.replaceAll("/", "\\\\");
            str = str.replaceAll("\\\\+", "\\\\");
        }
        return str;
    }
}

