package com.chinamcloud.common.cache.autoconfigure;

import com.chinamcloud.common.cache.properties.MemcacheProperties;
import lombok.extern.slf4j.Slf4j;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/5/4
 * Time: 上午10:12
 */
@Slf4j
@Configuration
@EnableCaching
@ComponentScan(basePackages={"com.chinamcloud.common.cache"})
public class MemcacheClientAutoConfiguration {

    @Autowired
    private MemcacheProperties memcacheProperties;

    @Bean
    public XMemcachedClientBuilder xmemcachedClientBuilderBean(){
        String cache_url = memcacheProperties.getMemcached_url();
        Map<InetSocketAddress, InetSocketAddress> addressMap = new HashMap<>();
        for (String address : cache_url.split(",")) {
            String[] addressSplit = address.split(":");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(addressSplit[0], Integer.parseInt(addressSplit[1]));
            addressMap.put(inetSocketAddress, inetSocketAddress);
        }
        XMemcachedClientBuilder xmemcachedClientBuilder = new XMemcachedClientBuilder(addressMap);
        xmemcachedClientBuilder.setConnectionPoolSize(memcacheProperties.getMemcached_pool_size());
        xmemcachedClientBuilder.setCommandFactory(new BinaryCommandFactory());
        KetamaMemcachedSessionLocator ketamaMemcachedSessionLocator = new KetamaMemcachedSessionLocator();
        xmemcachedClientBuilder.setSessionLocator(ketamaMemcachedSessionLocator);
        SerializingTranscoder serializingTranscoder = new SerializingTranscoder();
        xmemcachedClientBuilder.setTranscoder(serializingTranscoder);
        return xmemcachedClientBuilder;
    }

    @Bean
    public MemcachedClient memcachedClientBean(){
        MemcachedClient memcachedClient = null;
        try {
            memcachedClient = xmemcachedClientBuilderBean().build();
            return memcachedClient;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
