package com.chinamclound.common.cache.client;

import com.chinamcloud.common.cache.constant.CacheConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.*;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/5/11
 * Time: 下午1:44
 */
@Component("redisCommonClient")
public class RedisCommonClient{

    //Spring Boot已为我们配置RedisTemplate，在此处可以直接注入
    @Autowired
    private RedisTemplate<Object,Object> redisTemplate;
    //可以使用@Resource注解指定redisTmplate，可以注入基于对象的简单属性操作
    @Resource(name = "redisTemplate")
    private ValueOperations<Object,Object> valueOperations;
    /**
     * 保存到缓存
     * @param key：缓存的键
     * @param value：缓存的值
     * @param expireTime：过期时间,单位秒
     * @return
     */
    public boolean set(String key, Object value, Integer expireTime) {
        valueOperations.set(key,value,expireTime.longValue(), TimeUnit.SECONDS);
        return true;
    }
    /**
     * 保存到缓存,默认30天
     * @param key：缓存的键
     * @param value：缓存的值
     * @return
     */
    public boolean set(String key, Object value) {
        return set(key,value, CacheConstant.ONE_MONTH_EXPIRED_TIME);
    }

    /**
     * 获得缓存key相关的值
     * @param key
     * @return
     */
    public Object get(String key) {
        return valueOperations.get(key);
    }

    /**
     * 删除缓存数据
     * @param key
     * @return
     */
    public boolean delete(String key) {
        redisTemplate.delete(key);
        return true;
    }

    /**
     * 指定key是否存在
     * @param key
     * @return
     */
    public boolean isExist(String key) {
        return redisTemplate.hasKey(key);
    }

    /**
     * 指定的key自增
     * @param key
     * @param delta:增量
     * @return
     */
    public Long incr(String key, Long delta) {
        return valueOperations.increment(key,delta);
    }

    /**
     * 数据缓存在set集合中
     * @param key
     * @param dataSet
     */
    public void setCacheSet(Object key, Set<Object> dataSet) {
        BoundSetOperations<Object, Object> setOperations = redisTemplate.boundSetOps(key);
        setOperations.add(key,dataSet);
    }

    /**
     * 数据缓存在set集合中
     * @param key
     * @param value
     */
    public void setCacheSet(Object key, Object value) {
        BoundSetOperations<Object, Object> setOperations = redisTemplate.boundSetOps(key);
        setOperations.add(key,value);
    }

    /**
     * 返回set集合中的数据
     * @param key
     */
    public Set<Object> getCacheSet(Object key) {
        BoundSetOperations<Object, Object> setOperations = redisTemplate.boundSetOps(key);
        Set<Object> members = setOperations.members();
        return members;
    }

}
