package com.chinamcloud.common.cache.client;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/4/27
 * Time: 上午11:23
 */
public interface CacheClient {
    /**
     * 保存到缓存
     * @param key：缓存的键
     * @param expireTime：过期时间,单位秒
     * @param value：缓存的值
     * @return
     */
    boolean set(String key,int expireTime,Object value);
    /**
     * 保存到缓存,默认30天
     * @param key：缓存的键
     * @param value：缓存的值
     * @return
     */
    boolean set(String key,Object value);

    /**
     * 获得缓存key相关的值
     * @param key
     * @return
     */
    Object get(String key);

    /**
     * 删除缓存数据
     * @param key
     * @return
     */
    boolean delete(String key);

    /**
     * 指定key是否存在
     * @param key
     * @return
     */
    boolean isExist(String key);

    /**
     * 使所有连接的memcached的数据项无效
     */
    boolean flushAll();

    /**
     * 指定的key自增
     * @param key
     * @param delta:增量
     * @param initValue:初始值
     * @return
     */
    Long incr(String key,Long delta,Long initValue);

    /**
     * 指定的key自增
     * @param key
     * @param delta:增量
     * @param initValue:初始值
     * @return
     */
    Long incr(String key,Long delta,Long initValue,long timeout,int expireTime);


    /**
     * 指定的key自减
     * @param key
     * @param delta:增量
     * @param initValue:初始值
     * @return
     */
    Long decr(String key,Long delta,Long initValue);

    /**
     * 指定的key自减
     * @param key
     * @param delta:增量
     * @param initValue:初始值
     * @return
     */
    Long decr(String key,Long delta,Long initValue,long timeout,int expireTime);
}
