package com.chinamcloud.common.cache.client.impl;

import com.chinamcloud.common.cache.client.CacheClient;
import lombok.extern.slf4j.Slf4j;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeoutException;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/4/27
 * Time: 下午1:36
 */
@Slf4j
@Component("memcachedCommonClient")
public class MemcachedCommonClient implements CacheClient {

    private Integer Default_ExprierTime =24*60*60;
    private Long Default_Timeout =5000L;

    @Autowired
    private MemcachedClient memcachedClient;

    public boolean set(String key, int expireTime, Object value){
        try {
            return memcachedClient.set(key,expireTime,value);
        } catch (InterruptedException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        } catch (MemcachedException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        } catch (TimeoutException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        }
        return false;
    }

    public boolean set(String key, Object value){
        try {
            return memcachedClient.set(key,0,value);
        } catch (InterruptedException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        } catch (MemcachedException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        } catch (TimeoutException e) {
            log.error("缓存数据遇到异常,key:"+key,e);
        }
        return false;
    }

    @Override
    public Object get(String key) {
        try {
            return memcachedClient.get(key);
        } catch (TimeoutException e) {
            log.error("获取缓存数据遇到异常,key:"+key,e);
        } catch (InterruptedException e) {
            log.error("获取缓存数据遇到异常,key:"+key,e);
        } catch (MemcachedException e) {
            log.error("获取缓存数据遇到异常,key:"+key,e);
        }
        return null;
    }

    @Override
    public boolean delete(String key){
        try {
            return memcachedClient.delete(key);
        } catch (TimeoutException e) {
            log.error("删除缓存数据遇到异常,key:"+key,e);
        } catch (InterruptedException e) {
            log.error("删除缓存数据遇到异常,key:"+key,e);
        } catch (MemcachedException e) {
            log.error("删除缓存数据遇到异常,key:"+key,e);
        }
        return false;
    }

    @Override
    public boolean isExist(String key) {
        return null != get(key);
    }

    @Override
    public boolean flushAll() {
        try {
            memcachedClient.flushAll();
            return true;
        } catch (TimeoutException e) {
            log.error("所有缓存数据置为无效遇到异常:",e);
        } catch (InterruptedException e) {
            log.error("所有缓存数据置为无效遇到异常:",e);
        } catch (MemcachedException e) {
            log.error("所有缓存数据置为无效遇到异常:",e);
        }
        return false;
    }

    @Override
    public Long incr(String key,Long delta,Long initValue){
        return incr(key,delta,initValue,Default_Timeout, Default_ExprierTime);
    }


    @Override
    public Long incr(String key,Long delta,Long initValue,long timeout,int expireTime){
        try {
            return memcachedClient.incr(key,delta,initValue,timeout,expireTime);
        } catch (TimeoutException e) {
            log.error("缓存数据自增遇到异常:",e);
        } catch (InterruptedException e) {
            log.error("缓存数据自增遇到异常:",e);
        } catch (MemcachedException e) {
            log.error("缓存数据自增遇到异常:",e);
        }
        throw new RuntimeException("缓存数据自增遇到异常") ;
    }

    @Override
    public Long decr(String key,Long delta,Long initValue){
        return decr(key,delta,initValue,Default_Timeout, Default_ExprierTime);
    }

    @Override
    public Long decr(String key,Long delta,Long initValue,long timeout,int expireTime){
        try {
            return memcachedClient.incr(key,delta,initValue,timeout,expireTime);
        } catch (TimeoutException e) {
            log.error("缓存数据自增遇到异常:",e);
        } catch (InterruptedException e) {
            log.error("缓存数据自增遇到异常:",e);
        } catch (MemcachedException e) {
            log.error("缓存数据自增遇到异常:",e);
        }
        throw new RuntimeException("缓存数据自增遇到异常") ;
    }

}
