/*
 * Decompiled with CFR 0.152.
 */
package com.chinamclound.common.datasource.autoconfigure;

import com.alibaba.druid.pool.DruidDataSource;
import com.chinamclound.common.datasource.properties.DatabaseProperties;
import com.chinamclound.common.datasource.transformer.DatabaseProperties2DruidDataSource;
import com.github.pagehelper.PageHelper;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;

@Configuration
@EnableTransactionManagement
@ComponentScan(basePackages={"com.chinamclound.common.datasource"})
public class SingleDatabaseAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SingleDatabaseAutoConfiguration.class);
    @Autowired
    private DatabaseProperties databaseProperties;

    @Primary
    @Bean(initMethod="init", destroyMethod="close")
    public DruidDataSource dataSource() {
        if (StringUtils.isEmpty((Object)this.databaseProperties.getUrl())) {
            log.error("Your database connection pool configuration is incorrect! Please check your Spring profile:datasource.properties");
            throw new ApplicationContextException("Database connection pool is not configured correctly");
        }
        log.info("*** druidDataSource init begin ***");
        DruidDataSource druidDataSource = (DruidDataSource)DatabaseProperties2DruidDataSource.INSTANCE.apply((Object)this.databaseProperties);
        log.info("*** druidDataSource init end ***");
        return druidDataSource;
    }

    @Bean(value={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean() throws Exception {
        log.info("*** sqlSessionFactoryBean init begin ***");
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource((DataSource)this.dataSource());
        PageHelper pageHelper = new PageHelper();
        Properties properties = new Properties();
        properties.setProperty("dialect", "mysql");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("returnPageInfo", "check");
        properties.setProperty("params", "count=countSql");
        pageHelper.setProperties(properties);
        sqlSessionFactoryBean.setPlugins(new Interceptor[]{pageHelper});
        if (!StringUtils.isEmpty((Object)this.databaseProperties.getMybatisXml())) {
            log.info("mybatis XmlLocationPattern :{}", (Object)this.databaseProperties.getMybatisXml());
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            sqlSessionFactoryBean.setMapperLocations(pathMatchingResourcePatternResolver.getResources(this.databaseProperties.getMybatisXml()));
        }
        log.info("*** sqlSessionFactoryBean init end ***");
        return sqlSessionFactoryBean.getObject();
    }

    @Bean
    public PlatformTransactionManager platformTransactionManagerBean() throws SQLException {
        log.info("*** dataSourceTransactionManager init begin ***");
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager((DataSource)this.dataSource());
        log.info("*** dataSourceTransactionManager init end ***");
        return dataSourceTransactionManager;
    }
}

