/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.sign.service.impl;

import com.chinamcloud.common.sign.constant.SignType;
import com.chinamcloud.common.sign.service.SignService;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rsaSignService")
public class RSASignService
implements SignService {
    private static final Logger log = LoggerFactory.getLogger(RSASignService.class);

    @Override
    public String getSignType() {
        return SignType.RSA.getCode();
    }

    @Override
    public String sign(String data, byte[] privateKey) {
        byte[] sign = this.sign(data.getBytes(), privateKey);
        return Hex.encodeHexString((byte[])sign);
    }

    @Override
    public byte[] sign(byte[] data, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
            Signature signature = Signature.getInstance(SignType.SIGNATURE_MD5withRSA.getCode());
            signature.initSign(keyFactory.generatePrivate(pkcs8EncodedKeySpec));
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            log.error("rsa signature encountered an exception.", (Throwable)e);
            throw new RuntimeException("rsa signature encountered an exception.", e);
        }
    }

    @Override
    public boolean verify(String data, String sign, byte[] publicKey) {
        try {
            return this.verify(data.getBytes(), Hex.decodeHex((char[])sign.toCharArray()), publicKey);
        }
        catch (Exception e) {
            log.error("rsa verification signature encountered an exception.", (Throwable)e);
            throw new RuntimeException("rsa verification signature encountered an exception.", e);
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] sign, byte[] publicKey) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
            Signature signature = Signature.getInstance(SignType.SIGNATURE_MD5withRSA.getCode());
            signature.initVerify(keyFactory.generatePublic(x509EncodedKeySpec));
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            log.error("rsa verification signature encountered an exception.", (Throwable)e);
            throw new RuntimeException("rsa verification signature encountered an exception.", e);
        }
    }
}

