/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.sign.utils;

import com.chinamcloud.common.sign.constant.SignType;
import com.google.common.collect.Maps;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtil.class);
    @Autowired
    @Qualifier(value="myMessageSource")
    private MessageSource messageSource;
    private Map<String, String> configPublicKeyFilePathMap = Maps.newConcurrentMap();
    private Map<String, byte[]> publicKeyMap = Maps.newConcurrentMap();
    private Map<String, String> configPrivateKeyFilePathMap = Maps.newConcurrentMap();
    private Map<String, byte[]> privateKeyMap = Maps.newConcurrentMap();

    public byte[] getPublicKeyByTenantId(String applicationName, String signType) {
        try {
            String mapKey = this.getMapKey(applicationName, signType, "publicKey");
            String filePath = this.messageSource.getMessage(mapKey, null, null);
            if (StringUtils.isEmpty((Object)filePath)) {
                String errorMessage = "Can not find the public key file.";
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            if (this.configPublicKeyFilePathMap.containsKey(mapKey)) {
                String filePathByMap = this.configPublicKeyFilePathMap.get(mapKey);
                if (!filePath.equals(filePathByMap)) {
                    this.publicKeyMap.remove(filePathByMap);
                    this.configPublicKeyFilePathMap.put(mapKey, filePath);
                }
            } else {
                this.configPublicKeyFilePathMap.put(mapKey, filePath);
            }
            if (this.publicKeyMap.containsKey(filePath)) {
                return this.publicKeyMap.get(filePath);
            }
            byte[] bytesByPublic = this.getKeyByFileBytes(filePath);
            KeyFactory keyFactoryByPublic = KeyFactory.getInstance(SignType.RSA.getCode());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(bytesByPublic);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyFactoryByPublic.generatePublic(x509EncodedKeySpec);
            byte[] encoded = rsaPublicKey.getEncoded();
            this.publicKeyMap.put(filePath, encoded);
            return encoded;
        }
        catch (Exception e) {
            String errorMessage = "Read the public key encountered an error.";
            log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private String getMapKey(String applicationName, String signType, String keyType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((Object)applicationName)) {
            stringBuffer.append(applicationName).append(".");
        }
        stringBuffer.append(signType).append(".").append(keyType);
        return stringBuffer.toString();
    }

    public byte[] getLocalServerPrivateKey(String signType) {
        try {
            String mapKey = this.getMapKey("local_server", signType, "privateKey");
            String filePath = this.messageSource.getMessage(mapKey, null, null);
            if (StringUtils.isEmpty((Object)filePath)) {
                String errorMessage = "Can not find the private key file.";
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            if (this.configPrivateKeyFilePathMap.containsKey(mapKey)) {
                String filePathByMap = this.configPrivateKeyFilePathMap.get(mapKey);
                if (!filePath.equals(filePathByMap)) {
                    this.publicKeyMap.remove(filePathByMap);
                    this.configPrivateKeyFilePathMap.put(mapKey, filePath);
                }
            } else {
                this.configPrivateKeyFilePathMap.put(mapKey, filePath);
            }
            if (this.privateKeyMap.containsKey(mapKey)) {
                return this.privateKeyMap.get(mapKey);
            }
            byte[] bytesByPrivate = this.getKeyByFileBytes(filePath);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(bytesByPrivate);
            KeyFactory keyFactoryByPrivate = KeyFactory.getInstance(SignType.RSA.getCode());
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyFactoryByPrivate.generatePrivate(pkcs8EncodedKeySpec);
            byte[] encoded = rsaPrivateKey.getEncoded();
            this.privateKeyMap.put(filePath, encoded);
            return encoded;
        }
        catch (Exception e) {
            String errorMessage = "Read the private key encountered an error.";
            log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] getKeyByFileBytes(String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

