/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.sign.utils;

import com.chinamcloud.common.sign.constant.SignType;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Hex;

public class RSAUtil {
    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        return RSAUtil.encryptByPrivateKey(data, RSAUtil.getKey(privateKey));
    }

    public static byte[] encryptByPrivateKey(byte[] data, byte[] privateKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, keyFactory.generatePrivate(pkcs8EncodedKeySpec));
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        return RSAUtil.decryptByPrivateKey(data, RSAUtil.getKey(privateKey));
    }

    public static byte[] decryptByPrivateKey(byte[] data, byte[] privateKey) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, keyFactory.generatePrivate(pkcs8EncodedKeySpec));
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        return RSAUtil.encryptByPublicKey(data, RSAUtil.getKey(publicKey));
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] publicKey) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, keyFactory.generatePublic(x509EncodedKeySpec));
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(byte[] data, String publicKey) throws Exception {
        return RSAUtil.decryptByPublicKey(data, RSAUtil.getKey(publicKey));
    }

    public static byte[] decryptByPublicKey(byte[] data, byte[] publicKey) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(SignType.RSA.getCode());
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, keyFactory.generatePublic(x509EncodedKeySpec));
        return cipher.doFinal(data);
    }

    public static byte[] getKey(String key) throws Exception {
        return Hex.decodeHex((char[])key.toCharArray());
    }
}

