/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.sign.utils;

import com.chinamcloud.common.sign.service.SignService;
import com.chinamcloud.common.sign.utils.PropertyUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SignUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    private ApplicationContext applicationContext;
    @Autowired
    private PropertyUtil propertyUtil;
    Map<String, SignService> signServiceMap = Maps.newConcurrentMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map contextSignServiceBeansMap = this.applicationContext.getBeansOfType(SignService.class);
        for (Map.Entry entry : contextSignServiceBeansMap.entrySet()) {
            if (this.signServiceMap.containsKey(((SignService)entry.getValue()).getSignType())) {
                String errorMessage = "There is the same authentication method:[" + ((SignService)entry.getValue()).getSignType() + "]";
                log.error(errorMessage);
                throw new RuntimeException(errorMessage);
            }
            this.signServiceMap.put(((SignService)entry.getValue()).getSignType(), (SignService)entry.getValue());
        }
    }

    public Map<String, String> sign(Map<String, String> parameterMap, String signType, byte[] privateKey) {
        try {
            SignService signService = this.getSignService(signType);
            Map<String, String> filterParameterMap = SignUtil.filterParameterMap(parameterMap);
            String parameter = SignUtil.createLinkString(filterParameterMap);
            String sign = signService.sign(parameter, privateKey);
            parameterMap.put("sign", sign);
            parameterMap.put("signType", signType);
            return parameterMap;
        }
        catch (Exception e) {
            log.error("signature encountered an exception", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map<String, String> sign(Map<String, String> parameterMap, String signType) {
        byte[] privateKey = this.propertyUtil.getLocalServerPrivateKey(signType);
        return this.sign(parameterMap, signType, privateKey);
    }

    private SignService getSignService(String signType) {
        SignService signService = this.signServiceMap.get(signType);
        if (signService == null) {
            String errorMessage = "Did not find the corresponding type of signature service.";
            log.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        return signService;
    }

    public boolean verify(Map<String, String> parameterMap) {
        try {
            String signType = parameterMap.get("signType");
            String applicationName = parameterMap.get("applicationName");
            byte[] publicKey = this.propertyUtil.getPublicKeyByTenantId(applicationName, signType);
            Map<String, String> filterParameterMap = SignUtil.filterParameterMap(parameterMap);
            SignService signService = this.getSignService(signType);
            String sign = parameterMap.get("sign");
            String parameter = SignUtil.createLinkString(filterParameterMap);
            return signService.verify(parameter, sign, publicKey);
        }
        catch (Exception e) {
            log.error("verification signature encountered an exception.", (Throwable)e);
            throw new RuntimeException("verification signature encountered an exception.", e);
        }
    }

    private static Map<String, String> filterParameterMap(Map<String, String> parameterMap) {
        HashMap result = Maps.newHashMap();
        if (parameterMap == null || parameterMap.size() <= 0) {
            return result;
        }
        for (String key : parameterMap.keySet()) {
            String value = parameterMap.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("signType")) continue;
            result.put(key, value);
        }
        return result;
    }

    private static String createLinkString(Map<String, String> parameterMap) {
        ArrayList<String> keys = new ArrayList<String>(parameterMap.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = parameterMap.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }
}

