/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.properties;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProperties {
    private static final Logger log = LoggerFactory.getLogger(StorageProperties.class);
    private String oss_accessKeyId;
    private String oss_accessKeySecret;
    private int oss_taskNum = 2;
    private long oss_partSize = 0x100000L;

    public String getOss_accessKeyId() {
        return this.oss_accessKeyId;
    }

    public String getOss_accessKeySecret() {
        return this.oss_accessKeySecret;
    }

    public int getOss_taskNum() {
        return this.oss_taskNum;
    }

    public long getOss_partSize() {
        return this.oss_partSize;
    }

    public static final StorageProperties getInstance() {
        return ParamsConfigHolder.storageProperties;
    }

    private StorageProperties() {
        this.initialization();
    }

    private void initialization() {
        String configPath = "config/storage.properties";
        log.info("*** StorageProperties init begin ***");
        try {
            Object oss_partSize;
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(configPath);
            Object oss_accessKeyId = propertiesConfiguration.getProperty("oss_accessKeyId");
            if (oss_accessKeyId == null || StringUtils.isBlank((String)oss_accessKeyId.toString())) {
                throw new RuntimeException(configPath + " oss_accessKeyId is null");
            }
            this.oss_accessKeyId = oss_accessKeyId.toString().trim();
            Object oss_accessKeySecret = propertiesConfiguration.getProperty("oss_accessKeySecret");
            if (oss_accessKeySecret == null && StringUtils.isBlank((String)oss_accessKeySecret.toString())) {
                throw new RuntimeException(configPath + " oss_accessKeySecret is null");
            }
            this.oss_accessKeySecret = oss_accessKeySecret.toString().trim();
            Object oss_taskNum = propertiesConfiguration.getProperty("oss_taskNum");
            if (oss_taskNum != null && StringUtils.isNotBlank((String)oss_taskNum.toString())) {
                this.oss_taskNum = Integer.parseInt(oss_taskNum.toString().trim());
            }
            if ((oss_partSize = propertiesConfiguration.getProperty("oss_partSize")) != null && StringUtils.isNotBlank((String)oss_partSize.toString())) {
                this.oss_partSize = Long.parseLong(oss_partSize.toString().trim());
            }
            log.info("*** StorageProperties init end ***");
        }
        catch (ConfigurationException e) {
            log.error("StorageProperties init error,{}", (Object)configPath, (Object)e);
        }
    }

    private static class ParamsConfigHolder {
        private static final StorageProperties storageProperties = new StorageProperties();

        private ParamsConfigHolder() {
        }
    }
}

