/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.BucketBaseDTO;
import com.chinamcloud.common.storage.dto.BucketDTO;
import com.chinamcloud.common.storage.transformer.Bucket2DTOTransformer;
import com.chinamcloud.common.storage.util.OSSClientUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdStorageBucketUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdStorageBucketUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<BucketDTO> createBucket(BucketBaseDTO bucketBaseDTO) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageBucketUtil.checkBucketBaseDTO(bucketBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(bucketBaseDTO.getEndpoint());
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketBaseDTO.getBucketName());
        createBucketRequest.setCannedACL(CannedAccessControlList.parse((String)bucketBaseDTO.getCannedAccessControlList().name()));
        try {
            Bucket bucket = ossClient.createBucket(createBucketRequest);
            log.info("bucket:{}", (Object)JSON.toJSONString((Object)bucket, (boolean)true));
            BucketDTO bucketDTO = (BucketDTO)Bucket2DTOTransformer.INSTANCE.apply(bucket);
            ResultDTO resultDTO = ResultDTO.successfy((Object)bucketDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u521b\u5efa\u5b58\u50a8\u7a7a\u95f4\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u521b\u5efa\u5b58\u50a8\u7a7a\u95f4\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u521b\u5efa\u5b58\u50a8\u7a7a\u95f4\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u521b\u5efa\u5b58\u50a8\u7a7a\u95f4\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<Boolean> deleteBucket(BucketBaseDTO bucketBaseDTO) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageBucketUtil.checkBucketBaseDTO(bucketBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(bucketBaseDTO.getEndpoint());
        try {
            ossClient.deleteBucket(bucketBaseDTO.getBucketName());
            log.info("bucketBaseDTO:{} is delete", (Object)bucketBaseDTO);
            ResultDTO resultDTO = ResultDTO.successfy((Object)true);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u5220\u9664\u5b58\u50a8\u7a7a\u95f4\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u5220\u9664\u5b58\u50a8\u7a7a\u95f4\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u5220\u9664\u5b58\u50a8\u7a7a\u95f4\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u5220\u9664\u5b58\u50a8\u7a7a\u95f4\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ResultDTO<Boolean> checkBucketBaseDTO(BucketBaseDTO bucketBaseDTO) {
        if (bucketBaseDTO == null) {
            return ResultDTO.fail((String)"bucketCreateDTO is not null");
        }
        if (StringUtils.isBlank((String)bucketBaseDTO.getEndpoint())) {
            return ResultDTO.fail((String)"endpoint is not null");
        }
        String bucketName = bucketBaseDTO.getBucketName();
        if (StringUtils.isBlank((String)bucketName)) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (bucketName.length() < 3 || bucketName.length() > 63) {
            return ResultDTO.fail((String)"3 <= bucketName.length < 63");
        }
        return ResultDTO.successfy((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<Boolean> isExistBucket(BucketBaseDTO bucketBaseDTO) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageBucketUtil.checkBucketBaseDTO(bucketBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(bucketBaseDTO.getEndpoint());
        try {
            boolean isExist = ossClient.doesBucketExist(bucketBaseDTO.getBucketName());
            ResultDTO resultDTO = ResultDTO.successfy((Object)isExist);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u67e5\u8be2\u5b58\u50a8\u7a7a\u95f4\u662f\u5426\u5b58\u5728\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u67e5\u8be2\u5b58\u50a8\u7a7a\u95f4\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u67e5\u8be2\u5b58\u50a8\u7a7a\u95f4\u662f\u5426\u5b58\u5728\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u67e5\u8be2\u5b58\u50a8\u7a7a\u95f4\u662f\u5426\u5b58\u5728\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }
}

