/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.storage.util;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.CompleteMultipartUploadResultDTO;
import com.chinamcloud.common.storage.dto.DownloadFileDTO;
import com.chinamcloud.common.storage.dto.FileBaseDTO;
import com.chinamcloud.common.storage.dto.FileDeleteDTO;
import com.chinamcloud.common.storage.dto.FileUploadDTO;
import com.chinamcloud.common.storage.dto.MetadataDTO;
import com.chinamcloud.common.storage.dto.SimpleUploadResultDTO;
import com.chinamcloud.common.storage.properties.StorageProperties;
import com.chinamcloud.common.storage.transformer.CompleteMultipartUploadResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.DownloadFileResult2DTOTransformer;
import com.chinamcloud.common.storage.transformer.ObjectMetadata2MetadataDTOTransformer;
import com.chinamcloud.common.storage.transformer.PutObjectResult2SimpleUploadResultDTOTransformer;
import com.chinamcloud.common.storage.util.OSSClientUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdStorageFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdStorageFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<SimpleUploadResultDTO> simpleUploadByInputStream(FileUploadDTO fileUploadDTO, InputStream inputStream) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(fileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (inputStream == null) {
            return ResultDTO.fail((String)"input inputStream is not null");
        }
        FileBaseDTO fileBaseDTO = fileUploadDTO.getFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(fileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), inputStream, objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            SimpleUploadResultDTO simpleUploadResultDTO = (SimpleUploadResultDTO)PutObjectResult2SimpleUploadResultDTOTransformer.INSTANCE.apply(putObjectResult);
            ResultDTO resultDTO = ResultDTO.successfy((Object)simpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<SimpleUploadResultDTO> simpleUploadByFilePath(FileUploadDTO fileUploadDTO, String uploadFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(fileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"input filePath is not null");
        }
        FileBaseDTO fileBaseDTO = fileUploadDTO.getFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(fileUploadDTO);
        PutObjectRequest putObjectRequest = new PutObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName(), new File(uploadFilePath), objectMetadata);
        try {
            PutObjectResult putObjectResult = ossClient.putObject(putObjectRequest);
            log.info("putObjectResult:{}", (Object)JSON.toJSONString((Object)putObjectResult, (boolean)true));
            SimpleUploadResultDTO simpleUploadResultDTO = (SimpleUploadResultDTO)PutObjectResult2SimpleUploadResultDTOTransformer.INSTANCE.apply(putObjectResult);
            ResultDTO resultDTO = ResultDTO.successfy((Object)simpleUploadResultDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<CompleteMultipartUploadResultDTO> uploadByBreakpointsContinuedTransmission(FileUploadDTO fileUploadDTO, String uploadFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileUploadDTO(fileUploadDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)uploadFilePath)) {
            return ResultDTO.fail((String)"uploadFilePath is not null");
        }
        FileBaseDTO fileBaseDTO = fileUploadDTO.getFileBaseDTO();
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        UploadFileRequest uploadFileRequest = new UploadFileRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName());
        uploadFileRequest.setUploadFile(uploadFilePath);
        uploadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        uploadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        uploadFileRequest.setEnableCheckpoint(true);
        ObjectMetadata objectMetadata = ThirdStorageFileUtil.getObjectMetadata(fileUploadDTO);
        uploadFileRequest.setObjectMetadata(objectMetadata);
        try {
            UploadFileResult uploadFileResult = ossClient.uploadFile(uploadFileRequest);
            CompleteMultipartUploadResult completeMultipartUploadResult = uploadFileResult.getMultipartUploadResult();
            log.info("completeMultipartUploadResult\uff1a{}", (Object)JSON.toJSONString((Object)completeMultipartUploadResult, (boolean)true));
            CompleteMultipartUploadResultDTO completeMultipartUploadResultDTO = (CompleteMultipartUploadResultDTO)CompleteMultipartUploadResult2DTOTransformer.INSTANCE.apply(completeMultipartUploadResult);
            ResultDTO resultDTO = ResultDTO.successfy((Object)completeMultipartUploadResultDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0a\u4f20-\u9047\u5230\u5f02\u5e38", throwable);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u65ad\u70b9\u7eed\u4f20-\u4e0a\u4f20-\u9047\u5230\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ObjectMetadata getObjectMetadata(FileUploadDTO fileUploadBaseDTO) {
        Map<String, String> userMetadataMap;
        if (fileUploadBaseDTO.getMetadataDTO() == null) {
            return null;
        }
        Map<String, Object> metadataMap = fileUploadBaseDTO.getMetadataDTO().getMetadataMap();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        if (MapUtils.isNotEmpty(metadataMap)) {
            for (String key : metadataMap.keySet()) {
                objectMetadata.setHeader(key, metadataMap.get(key));
            }
        }
        if (MapUtils.isNotEmpty(userMetadataMap = fileUploadBaseDTO.getMetadataDTO().getUserMetadataMap())) {
            objectMetadata.setUserMetadata(userMetadataMap);
        }
        return objectMetadata;
    }

    private static ResultDTO<Boolean> checkFileUploadDTO(FileUploadDTO fileUploadDTO) {
        if (fileUploadDTO == null) {
            return ResultDTO.fail((String)"fileUploadBaseInfoDTO is not null");
        }
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(fileUploadDTO.getFileBaseDTO());
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        return ResultDTO.successfy((Object)true);
    }

    private static ResultDTO<Boolean> checkFileBaseDTO(FileBaseDTO fileBaseDTO) {
        if (fileBaseDTO == null) {
            return ResultDTO.fail((String)"fileBaseDTO is not null");
        }
        if (StringUtils.isBlank((String)fileBaseDTO.getEndpoint())) {
            return ResultDTO.fail((String)"endpoint is not null");
        }
        if (StringUtils.isBlank((String)fileBaseDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (StringUtils.isBlank((String)fileBaseDTO.getFileName())) {
            return ResultDTO.fail((String)"fileName is not null");
        }
        String fileName = fileBaseDTO.getFileName();
        String firstString = fileName.substring(0, 1);
        if ("/".equals(firstString) || "\\".equals(firstString)) {
            return ResultDTO.fail((String)"\u4e0d\u80fd\u4ee5'/'\u6216\u8005''\u5b57\u7b26\u5f00\u5934");
        }
        if (fileName.length() >= 1023) {
            return ResultDTO.fail((String)"1 <= fileName.length < 1023");
        }
        return ResultDTO.successfy((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<MetadataDTO> simpleDownloadToFile(FileBaseDTO fileBaseDTO, String downloadSaveFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(fileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"input filePath is null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        try {
            ObjectMetadata objectMetadata = ossClient.getObject(new GetObjectRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName()), new File(downloadSaveFilePath));
            MetadataDTO metadataDTO = (MetadataDTO)ObjectMetadata2MetadataDTOTransformer.INSTANCE.apply(objectMetadata);
            log.info("metadataDTO:{}", (Object)JSON.toJSONString((Object)metadataDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)metadataDTO);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<DownloadFileDTO> downloadByBreakpointsContinuedTransmission(FileBaseDTO fileBaseDTO, String downloadSaveFilePath) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(fileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        if (StringUtils.isBlank((String)downloadSaveFilePath)) {
            return ResultDTO.fail((String)"downloadFilePath is not null");
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        DownloadFileRequest downloadFileRequest = new DownloadFileRequest(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName());
        downloadFileRequest.setDownloadFile(downloadSaveFilePath);
        downloadFileRequest.setTaskNum(StorageProperties.getInstance().getOss_taskNum());
        downloadFileRequest.setPartSize(StorageProperties.getInstance().getOss_partSize());
        downloadFileRequest.setEnableCheckpoint(true);
        try {
            DownloadFileDTO downloadFileDTO = (DownloadFileDTO)DownloadFileResult2DTOTransformer.INSTANCE.apply(ossClient.downloadFile(downloadFileRequest));
            log.info("downloadFileDTO:{}", (Object)JSON.toJSONString((Object)downloadFileDTO, (boolean)true));
            ResultDTO resultDTO = ResultDTO.successfy((Object)downloadFileDTO);
            return resultDTO;
        }
        catch (Throwable throwable) {
            log.error("\u65ad\u70b9\u7eed\u4f20-\u4e0b\u8f7d-\u9047\u5230\u5f02\u5e38", throwable);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u65ad\u70b9\u7eed\u4f20-\u4e0b\u8f7d-\u9047\u5230\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<List<String>> deleteFiles(FileDeleteDTO fileDeleteDTO) {
        ResultDTO resultDTO;
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileDeleteDTO(fileDeleteDTO);
        if (!booleanResultDTO.isSuccess()) {
            return ResultDTO.fail((String)booleanResultDTO.getDescription());
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(fileDeleteDTO.getEndpoint());
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(fileDeleteDTO.getBucketName()).withKeys(fileDeleteDTO.getFileNameList());
        try {
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(deleteObjectsRequest);
            List deletedObjects = deleteObjectsResult.getDeletedObjects();
            if (CollectionUtils.isEmpty((Collection)deletedObjects)) {
                ResultDTO resultDTO2 = ResultDTO.fail((String)"\u5168\u90e8\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                return resultDTO2;
            }
            ResultDTO resultDTO3 = ResultDTO.successfy((Object)deletedObjects);
            return resultDTO3;
        }
        catch (OSSException ossException) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            resultDTO = ResultDTO.fail((String)("\u5220\u9664\u6587\u4ef6\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u5220\u9664\u6587\u4ef6\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            resultDTO = ResultDTO.fail((String)"\u5220\u9664\u6587\u4ef6\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }

    private static ResultDTO<Boolean> checkFileDeleteDTO(FileDeleteDTO fileDeleteDTO) {
        if (fileDeleteDTO == null) {
            return ResultDTO.fail((String)"fileDeleteDTO is not null");
        }
        if (StringUtils.isBlank((String)fileDeleteDTO.getEndpoint())) {
            return ResultDTO.fail((String)"endpoint is not null");
        }
        if (StringUtils.isBlank((String)fileDeleteDTO.getBucketName())) {
            return ResultDTO.fail((String)"bucketName is not null");
        }
        if (CollectionUtils.isEmpty(fileDeleteDTO.getFileNameList())) {
            return ResultDTO.fail((String)"fileNameList is not empty");
        }
        if (fileDeleteDTO.getFileNameList().size() > 1000) {
            return ResultDTO.fail((String)"fileNameLise size <=1000 ");
        }
        return ResultDTO.successfy((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultDTO<Boolean> isExistFile(FileBaseDTO fileBaseDTO) {
        ResultDTO<Boolean> booleanResultDTO = ThirdStorageFileUtil.checkFileBaseDTO(fileBaseDTO);
        if (!booleanResultDTO.isSuccess()) {
            return booleanResultDTO;
        }
        OSSClient ossClient = OSSClientUtil.createOssClient(fileBaseDTO.getEndpoint());
        try {
            boolean isExist = ossClient.doesObjectExist(fileBaseDTO.getBucketName(), fileBaseDTO.getFileName());
            ResultDTO resultDTO = ResultDTO.successfy((Object)isExist);
            return resultDTO;
        }
        catch (OSSException ossException) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230OSSException\u5f02\u5e38", (Throwable)ossException);
            ResultDTO resultDTO = ResultDTO.fail((String)("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5f02\u5e38:" + ossException.getMessage()));
            return resultDTO;
        }
        catch (ClientException e) {
            log.error("\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230ClientException\u5f02\u5e38", (Throwable)e);
            ResultDTO resultDTO = ResultDTO.fail((String)"\u786e\u5b9a\u6587\u4ef6\u662f\u5426\u5b58\u5728\u9047\u5230\u5ba2\u6237\u7aef\u5f02\u5e38");
            return resultDTO;
        }
        finally {
            ossClient.shutdown();
        }
    }
}

