package com.chinamcloud.common.storage.dto;

import com.chinamcloud.common.storage.constant.CannedAccessControlList;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/9
 * Time: 下午4:41
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BucketBaseDTO {
    /**
     * 访问域名
     * 如果没有传递，默认使用华北2（北京）
     * @see com.chinamcloud.common.storage.constant.OSSEndPoint
     */
    private String endpoint;
    /**
     * 存储空间名称（必填）
     */
    private String bucketName;
    /**
     * bucket权限
     * @see com.chinamcloud.common.storage.constant.CannedAccessControlList
     */
    private CannedAccessControlList cannedAccessControlList = CannedAccessControlList.PublicRead;
}
