package com.chinamcloud.common.storage.dto;

import com.chinamcloud.common.storage.constant.StorageType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/10
 * Time: 下午4:36
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BucketDTO {
    /**
     * Bucket 名
     */
    private String name;

    /**
     * Bucket 所有者
     */
    private OwnerDTO ownerDTO;

    /**
     * Bucket 所在地
     */
    private String location;

    /**
     * 创建时间
     */
    private Date creationDate;

    /**
     * 存储类型
     * @see  com.chinamcloud.common.storage.constant.StorageType
     */
    private StorageType storageType;

    /**
     * 内部地址
     */
    private String extranetEndpoint;

    /**
     * 外部地址
     */
    private String intranetEndpoint;
}
