package com.chinamcloud.common.storage.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/10
 * Time: 下午3:59
 * 参：https://help.aliyun.com/document_detail/31859.html?spm=5176.doc31837.6.592.wxb9XZ
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MetadataDTO {
    /**
     * 非用户自定义的元数据
     * @see com.chinamcloud.common.storage.constant.HttpHeaders
     */
    private Map<String,Object> metadataMap;
    /**
     * 用户自定义的元数据，表示以x-oss-meta-为前缀的请求头。
     * @see com.chinamcloud.common.storage.constant.OSSConstant
     * key请小写字母
     */
    private Map<String,String> userMetadataMap;
}
