package com.chinamcloud.common.storage.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/11
 * Time: 上午10:15
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ThirdStorageSimpleUploadResultDTO {
    /**
     * 用于唯一标识该次请求的UUID
     */
    private String requestId;
    /**
     * OSS上的object会有etag标签，etag主要是用来判断服务端数据是否存在变化。
     * 但是，这个标签并不一定等同于文件的MD5值，所以不建议作为校验数据一致性的依据。
     */
    private String eTag;
    /**
     * 访问的完整路径（手动拼装的）
     * 示例：http://chinamcloud-java-test-czw.oss-cn-hangzhou.aliyuncs.com/java深度历险.pdf
     */
    private String location;
    /**
     * 服务端返回的crc64值
     * 客户端可以和本地计算的crc64值做对比，从而完成数据完整性的验证
     */
    private Long serverCRC;
    /**
     * 客户端的crc64值
     */
    private Long clientCRC;

}
