package com.chinamcloud.common.storage.properties;

import com.chinamcloud.common.storage.constant.OSSEndPoint;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/9
 * Time: 下午1:38
 */
@Slf4j
public class StorageProperties {
    /**
     * 阿里云oss_id
     */
    private String oss_accessKeyId;
    /**
     *  阿里云oss_key
     */
    private String oss_accessKeySecret;
    /**
     * 阿里云oss默认访问域名
     */
    private String oss_default_endpoint = OSSEndPoint.BEI_JING;
    /**
     * 断点续传默认并发数
     */
    private int oss_taskNum = 2;

    /**
     * 设置断点续传默认分片大小
     */
    private long oss_partSize = 1024 * 1024;

    public String getOss_accessKeyId() {
        return oss_accessKeyId;
    }

    public String getOss_accessKeySecret() {
        return oss_accessKeySecret;
    }

    public int getOss_taskNum() {
        return oss_taskNum;
    }

    public long getOss_partSize() {
        return oss_partSize;
    }

    public String getOss_default_endpoint() {
        return oss_default_endpoint;
    }

    private static class ParamsConfigHolder{
        private static final StorageProperties storageProperties = new StorageProperties();
    }
    public static final StorageProperties getInstance() {
        return ParamsConfigHolder.storageProperties;
    }

    private StorageProperties() {
        initialization();
    }

    private void initialization() {
        String configPath = "config/storage.properties";
        log.info("*** StorageProperties init begin ***");
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(configPath);
            Object oss_accessKeyId = propertiesConfiguration.getProperty("oss_accessKeyId");
            if(oss_accessKeyId == null || StringUtils.isBlank(oss_accessKeyId.toString())){
                throw new RuntimeException ("oss_accessKeyId is not null");
            }
            this.oss_accessKeyId = oss_accessKeyId.toString().trim();
            Object oss_accessKeySecret = propertiesConfiguration.getProperty("oss_accessKeySecret");
            if(oss_accessKeySecret == null && StringUtils.isBlank(oss_accessKeySecret.toString())){
                throw new RuntimeException("oss_accessKeySecret is not null");
            }
            Object oss_default_endpoint = propertiesConfiguration.getProperty("oss_default_endpoint");
            if(oss_default_endpoint != null || StringUtils.isNotBlank(oss_default_endpoint.toString())){
                this.oss_default_endpoint = oss_default_endpoint.toString().trim();
            }
            this.oss_accessKeySecret = oss_accessKeySecret.toString().trim();
            Object oss_taskNum = propertiesConfiguration.getProperty("oss_taskNum");
            if(oss_taskNum != null && StringUtils.isNotBlank(oss_taskNum.toString())){
                this.oss_taskNum = Integer.parseInt(oss_taskNum.toString().trim());
            }
            Object oss_partSize = propertiesConfiguration.getProperty("oss_partSize");
            if(oss_partSize != null && StringUtils.isNotBlank(oss_partSize.toString())){
                this.oss_partSize = Long.parseLong(oss_partSize.toString().trim());
            }
            log.info("*** StorageProperties init end ***");
        } catch (ConfigurationException e) {
            log.error("StorageProperties init error,{}",configPath,e);
        }
    }
}
