package com.chinamcloud.common.storage.transformer;

import com.aliyun.oss.model.PutObjectResult;
import com.chinamcloud.common.guava2.SafeFunction;
import com.chinamcloud.common.storage.dto.ThirdStorageSimpleUploadResultDTO;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/1/11
 * Time: 上午10:17
 */
public final class PutObjectResult2SimpleUploadResultDTOTransformer extends SafeFunction<PutObjectResult, ThirdStorageSimpleUploadResultDTO> {

    public static final PutObjectResult2SimpleUploadResultDTOTransformer INSTANCE = new PutObjectResult2SimpleUploadResultDTOTransformer();

    @Override
    protected ThirdStorageSimpleUploadResultDTO safeApply(PutObjectResult input) {
        ThirdStorageSimpleUploadResultDTO output = new ThirdStorageSimpleUploadResultDTO();
        output.setRequestId(input.getRequestId());
        output.setETag(input.getETag());
        output.setServerCRC(input.getServerCRC());
        output.setClientCRC(input.getClientCRC());
        return output;
    }

    private PutObjectResult2SimpleUploadResultDTOTransformer() {
    }
}