package com.chinamcloud.common.storage.util;

import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.*;
import com.chinamcloud.common.util.FileUtil;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItem;

import java.io.File;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/2/6
 * Time: 下午2:01
 */
@Slf4j
public class FileStorageUtil {

    public static void saveFile(FileStorageDTO fileStorageDTO) {
        File file;
        if(fileStorageDTO.isSupportOSSStorage()){
            file = writeStringToLocalFile(System.getProperty("java.io.tmpdir"),fileStorageDTO.getSaveFileName(),fileStorageDTO.getTextContent());
            ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = builderSimpleThirdStorageFileUploadDTO(
                    fileStorageDTO.getOssBucketName(), fileStorageDTO.getStorageParentPath(), fileStorageDTO.getSaveFileName());
            ResultDTO<ThirdStorageSimpleUploadResultDTO> thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.
                    simpleUploadByFilePath(thirdStorageFileUploadDTO, file.getAbsolutePath());
            if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
                deleteFileByCondition(file,true);
                throw new RuntimeException("上传到云存储失败:"+thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
            }
        }else {
            file = writeStringToLocalFile(fileStorageDTO.getStorageParentPath(),fileStorageDTO.getSaveFileName(),fileStorageDTO.getTextContent());
        }
        deleteFileByCondition(file,fileStorageDTO.isSupportOSSStorage());
    }

    public static File writeFileItemToLocalFile(String storageParentPath, String saveFileName, FileItem fileItem) throws Exception {
        File parentFile = new File(storageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = null;
        if(storageParentPath.endsWith("/")){
            filePath = new StringBuilder(storageParentPath).append(saveFileName).toString();
        }else {
            filePath = new StringBuilder(storageParentPath).append("/").append(saveFileName).toString();
        }
        File file = new File(filePath);
        fileItem.write(file);
        return file;
    }

    private static File writeStringToLocalFile(String storageParentPath, String saveFileName, String textContent) {
        File parentFile = new File(storageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String filePath = null;
        if(storageParentPath.endsWith("/")){
            filePath = new StringBuilder(storageParentPath).append(saveFileName).toString();
        }else {
            filePath = new StringBuilder(storageParentPath).append("/").append(saveFileName).toString();
        }
        com.chinamcloud.common.util.FileUtil.writeText(filePath,textContent);
        return new File(filePath);
    }

    public static ThirdStorageFileUploadDTO builderSimpleThirdStorageFileUploadDTO(String ossBucketName, String urlPartPath, String saveFileName) {
        ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = new ThirdStorageFileUploadDTO();
        ThirdStorageFileBaseDTO thirdStorageFileBaseDTO = new ThirdStorageFileBaseDTO();
        thirdStorageFileBaseDTO.setBucketName(ossBucketName);
        String ossFileName = null;
        if(urlPartPath.endsWith("/")){
            ossFileName = new StringBuilder(urlPartPath).append(saveFileName).toString();
        }else {
            ossFileName = new StringBuilder(urlPartPath).append("/").append(saveFileName).toString();
        }
        if (ossFileName.startsWith("/")) {
            ossFileName = ossFileName.substring(1);
        }
        thirdStorageFileBaseDTO.setFileName(ossFileName);
        thirdStorageFileUploadDTO.setThirdStorageFileBaseDTO(thirdStorageFileBaseDTO);
        return thirdStorageFileUploadDTO;
    }

    public static void deleteFileByCondition(File file, boolean isDelete) {
        if (isDelete && file.exists()) {
            file.delete();
        }
    }

    public static void deleteFile(String ossBucketName, List<String> deleteFilePathList) {
        if (CollectionUtils.isEmpty(deleteFilePathList)) {
            return;
        }
        int pageSize = 1000;
        int totalSize = deleteFilePathList.size();
        int pageNum = IntMath.divide(totalSize, pageSize, RoundingMode.CEILING);
        for (int m = 0; m < pageNum; m++) {
            ThirdStorageFileDeleteDTO thirdStorageFileDeleteDTO = new ThirdStorageFileDeleteDTO();
            thirdStorageFileDeleteDTO.setBucketName(ossBucketName);
            int fromIndex = m * pageSize;
            int toIndex = pageSize;
            if (m == (pageNum-1)) {
                fromIndex = m * pageSize;
                toIndex = totalSize;
            }
            List<String> subDeleteFilePathList = deleteFilePathList.subList(fromIndex, toIndex);
            thirdStorageFileDeleteDTO.setFileNameList(builderDeleteFileNameList(subDeleteFilePathList));
            ThirdStorageFileUtil.deleteFiles(thirdStorageFileDeleteDTO);
        }
        for (int i = 0; i < deleteFilePathList.size(); i++) {
            boolean delete = FileUtil.delete(deleteFilePathList.get(i));
            if (delete) {
                log.info("删除静态文件:{}", deleteFilePathList.get(i));
            } else {
                log.info("静态文件不存在，无需删除:{}", deleteFilePathList.get(i));
            }
        }
    }

    private static List<String> builderDeleteFileNameList(List<String> deleteFilePathList) {
        List<String> fileNameList = Lists.newArrayList();
        for (int i = 0; i < deleteFilePathList.size(); i++) {
            String deleteFilePath = deleteFilePathList.get(i);
            if (deleteFilePath.startsWith("/")) {
                fileNameList.add(deleteFilePath.substring(1));
            } else {
                fileNameList.add(deleteFilePath);
            }
        }
        return fileNameList;
    }
}
