/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.base;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.spider.code.SystemContants;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class ResultDTO<T>
implements Serializable {
    private T data;
    private Integer state;
    private String message;

    public ResultDTO() {
    }

    public ResultDTO(Integer state, String message) {
        this.state = state;
        this.message = message;
    }

    public ResultDTO(T data, Integer state, String message) {
        this.data = data;
        this.state = state;
        this.message = message;
    }

    public static <T> ResultDTO<T> success() {
        return ResultDTO.success(null);
    }

    public static <T> ResultDTO<T> success(T model) {
        return new ResultDTO<T>(model, SystemContants.SUCCESS.getCode(), SystemContants.SUCCESS.getMessage());
    }

    public boolean isSuccess() {
        return SystemContants.SUCCESS.getCode().equals(this.state);
    }

    public static <T> ResultDTO<T> fail(int state, String errorMsg) {
        return new ResultDTO<Object>(null, state, errorMsg);
    }

    public static <T> ResultDTO<T> fail(SystemContants systemContants) {
        return new ResultDTO<Object>(null, systemContants.getCode(), systemContants.getMessage());
    }

    public static <T> ResultDTO<T> fail() {
        return new ResultDTO<T>(SystemContants.FAILURE.getCode(), SystemContants.FAILURE.getMessage());
    }

    public static <T> ResultDTO<T> fail(String errorMessage) {
        return new ResultDTO<T>(SystemContants.FAILURE.getCode(), errorMessage);
    }

    public String toJSONString(String callback) {
        if (StringUtils.isBlank((String)callback)) {
            return JSON.toJSONString((Object)this);
        }
        StringBuilder stringBuilder = new StringBuilder(callback);
        stringBuilder.append("(").append(JSON.toJSONString((Object)this)).append(")");
        return stringBuilder.toString();
    }

    public T getData() {
        return this.data;
    }

    public Integer getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

