/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.guava2;

import com.chinamcloud.spider.guava2.Identifiable;
import com.chinamcloud.spider.guava2.Pair;
import com.chinamcloud.spider.guava2.SafeFunction;
import com.google.common.base.Function;
import org.apache.commons.lang.math.NumberUtils;

public final class Functions2 {
    private Functions2() {
    }

    public static <U> Function<Pair<U, ?>, U> newFirstOfPairFunction() {
        return FirstOfPairFunction.INSTANCE;
    }

    public static <U> Function<Pair<?, U>, U> newSecondOfPairFunction() {
        return SecondOfPairFunction.INSTANCE;
    }

    public static <F, T> Function<F, Pair<F, T>> newInAndOutFunction(Function<? super F, ? extends T> function) {
        return new InAndOutFunction(function);
    }

    public static <F extends Identifiable<T>, T> Function<F, T> newIdFunction() {
        return IdFunction.INSTANCE;
    }

    public static final class KeyValueIsSameFunction
    extends SafeFunction<Object, Object> {
        public static final KeyValueIsSameFunction INSTANCE = new KeyValueIsSameFunction();

        @Override
        protected Object safeApply(Object input) {
            return input;
        }
    }

    public static final class StringToIntegerFunction
    extends SafeFunction<String, Integer> {
        public static final StringToIntegerFunction INSTANCE = new StringToIntegerFunction();

        @Override
        protected Integer safeApply(String input) {
            return NumberUtils.toInt((String)input);
        }
    }

    private static final class IdFunction<F extends Identifiable<T>, T>
    extends SafeFunction<F, T> {
        public static final IdFunction INSTANCE = new IdFunction();

        private IdFunction() {
        }

        @Override
        public T safeApply(F input) {
            return input.getIdentify();
        }
    }

    private static final class SecondOfPairFunction<U>
    extends SafeFunction<Pair<?, U>, U> {
        public static final SecondOfPairFunction INSTANCE = new SecondOfPairFunction();

        private SecondOfPairFunction() {
        }

        @Override
        public U safeApply(Pair<?, U> input) {
            return input != null ? (U)input.getSecond() : null;
        }
    }

    private static final class FirstOfPairFunction<U>
    extends SafeFunction<Pair<U, ?>, U> {
        public static final FirstOfPairFunction INSTANCE = new FirstOfPairFunction();

        private FirstOfPairFunction() {
        }

        @Override
        public U safeApply(Pair<U, ?> input) {
            return input.getFirst();
        }
    }

    private static final class InAndOutFunction<F, T>
    implements Function<F, Pair<F, T>> {
        private final Function<? super F, ? extends T> function;

        private InAndOutFunction(Function<? super F, ? extends T> function) {
            this.function = function;
        }

        public Pair<F, T> apply(F input) {
            return Pair.of(input, this.function.apply(input));
        }
    }
}

