package com.chinamcloud.spider.base;

/**
 * Created by jyy on 17/6/6.
 */
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
@Slf4j
public class PageRequest implements Serializable {

    /**
     * 页号码,页码从1开始
     */
    private Integer pageNumber=1;
    /**
     * 分页大小
     */
    private Integer pageSize=10;
    /**
     * 排序的多个列,如: username desc
     */
//	private String sortColumns;
    /**
     * 查询排序
     */
    private String orderField;
    /**
     * 排序类型：升序降序
     */
    private String orderDirection = "desc";

    public PageRequest() {
        this(1,10);
    }


    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber,pageSize,"","");
    }


    public PageRequest(int pageNumber, int pageSize, String orderField, String orderDirection) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        setOrderField(orderField);
        setOrderDirection(orderDirection);
    }

    public Integer getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderField() {
        return orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderDirection() {
        return orderDirection;
    }

    public void setOrderDirection(String orderDirection) {
        if (StringUtils.isNotBlank(orderDirection)){
            final String checkSQL ="\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)";
            final Pattern pattern = Pattern.compile(checkSQL);
            Matcher matcher = pattern.matcher(orderDirection);
            while (matcher.find()) {
                log.error("非法请求");
                throw new RuntimeException("非法请求");
            }
        }
        this.orderDirection = orderDirection;
    }
}
