package com.chinamcloud.spider.utils;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/8/4
 * Time: 下午1:51
 */
public class AntPathUtil {

    public static boolean isMatch(String requestURI, List<String> patternPathList) {
        if (CollectionUtils.isEmpty(patternPathList)){
            return false;
        }
        while (requestURI.startsWith("/")){
            requestURI = requestURI.substring(1);
        }
        for (String patternPath : patternPathList){
            PathMatcher antPathMatcher = new AntPathMatcher();
            if (antPathMatcher.match(patternPath,requestURI)){
                return true;
            }
        }
        return false;
    }
}
