package com.chinamcloud.spider.utils;

import com.chinamcloud.spider.dto.MultipartBodyPartDto;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/7/19
 * Time: 下午7:03
 * 原来参数限定为Map<String, String> parameterMap，现推荐使用OkHttpUtil2，参数为：Map<String, Object> parameterMap
 * @see OkHttpUtil2
 */
@Slf4j
@Deprecated
public class OkHttpUtil {
    /**
     * get 方式提交
     * @param url : 请求的url
     * @param headerMap : 请求头
     * @param parameterMap : 请求参数
     * @return
     */
    public static String get(String url, Map<String,String> headerMap, Map<String, String> parameterMap){
        log.info("url:{},headerMap:{},parameter:{}",url,headerMap,parameterMap);
        OkHttpClient okHttpClient = new OkHttpClient();
        Request request = getRequest(url, headerMap, parameterMap);
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("请求url:{},返回:{}",url,jsonString);
                return jsonString;
            }
            log.error("服务器端错误", response.message());
        } catch (IOException e) {
            log.error("请求遇到异常", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private static Request getRequest(String url, Map<String, String> headerMap, Map<String, String> parameterMap) {
        String completeUrl = getCompleteUrl(url, parameterMap);
        Request.Builder builder = new Request.Builder();
        if(MapUtils.isNotEmpty(headerMap)){
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        return builder.url(completeUrl).build();
    }

    private static String getCompleteUrl(String url, Map<String, String> parameterMap) {
        if(MapUtils.isEmpty(parameterMap)){
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder(url).append("?");
        int index = 0;
        for (String key :parameterMap.keySet()){
            if(index > 0){
                stringBuilder.append("&");
            }
            stringBuilder.append(key).append("=").append(parameterMap.get(key));
            index++;
        }
        return stringBuilder.toString();
    }

    /**
     * 以json格式post提交
     * @param url : 请求的url
     * @param headerMap : 请求头
     * @param parameter : Json格式的数据
     * @return
     */
    public static String postByJson(String url, Map<String,String> headerMap, String parameter) {
        log.info("url:{},headerMap:{},parameter:{}",url,headerMap,parameter);
        MediaType MEDIA_TYPE_TEXT = MediaType.parse("application/json");
        RequestBody requestBody = RequestBody.create(MEDIA_TYPE_TEXT, parameter);
        return post(url, headerMap,requestBody);
    }

    private static String post(String url, Map<String, String> headerMap, RequestBody requestBody) {
        OkHttpClient okHttpClient = new OkHttpClient();
        Request.Builder builder = new Request.Builder();
        if(MapUtils.isNotEmpty(headerMap)){
            for (String key : headerMap.keySet()) {
                builder.addHeader(key, headerMap.get(key));
            }
        }
        Request request = builder.url(url).post(requestBody).build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String jsonString = response.body().string();
                log.info("请求url:{},返回:{}",url,jsonString);
                return jsonString;
            }
            log.error("服务器端错误", response.message());
        } catch (Exception e) {
            log.error("请求遇到异常", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    /**
     * 以form表单的形式提交
     * @param url : 请求的url
     * @param headerMap : 请求头
     * @param parameterMap : 请求参数，key:value
     * @return
     */
    public static String postByForm(String url, Map<String,String> headerMap, Map<String, String> parameterMap) {
        log.info("url:{},headerMap:{},parameter:{}",url,headerMap,parameterMap);
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if(MapUtils.isNotEmpty(parameterMap)){
            for(String key : parameterMap.keySet()){
                formBodyBuilder.add(key,parameterMap.get(key));
            }
        }
        RequestBody requestBody = formBodyBuilder.build();
        return post(url,headerMap,requestBody);

    }

    @Deprecated
    public static String uploadFile(String url, Map<String,String> headerMap, Map<String, String> parameterMap, Map<String,InputStream> inputStreamMap) {
        try {
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String,String> entry : parameterMap.entrySet()){
                    multipartBodyBuilder.addFormDataPart(entry.getKey(),entry.getValue());
                }
            }
            Request.Builder builder = new Request.Builder();
            if (MapUtils.isNotEmpty(headerMap)) {
                for (Map.Entry<String,String> entry : headerMap.entrySet()){
                    builder.addHeader(entry.getKey(),entry.getValue());
                }
            }
            if (MapUtils.isNotEmpty(inputStreamMap)) {
                try {
                    for (Map.Entry<String, InputStream> entry : inputStreamMap.entrySet()) {

                        multipartBodyBuilder.addFormDataPart(entry.getKey(), entry.getKey(), RequestBody.create(MediaType.parse("text/plain"),
                                IOUtils.toByteArray(entry.getValue())));
                    }

                } catch (IOException exception) {
                    log.error("inputStream 转换 byte[]异常", exception);
                    throw new RuntimeException(exception);
                }
            }
            RequestBody requestBody = multipartBodyBuilder.build();
            OkHttpClient okHttpClient = new OkHttpClient.Builder().
                    connectTimeout(500, TimeUnit.SECONDS).
                    writeTimeout(500, TimeUnit.SECONDS).
                    readTimeout(500, TimeUnit.SECONDS).
                    build();
            Request request = builder.url(url).post(requestBody).build();
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                log.info("请求url:{},parameterMap:{},返回:{}",url,parameterMap,result);
                return result;
            }
            log.error("服务器端错误", response.message());
        } catch (IOException e) {
            log.error("请求遇到异常", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String uploadFile(String url, Map<String,String> headerMap, Map<String, String> parameterMap, List<MultipartBodyPartDto> multipartBodyPartDtoList) {
        try {
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String,String> entry : parameterMap.entrySet()){
                    multipartBodyBuilder.addFormDataPart(entry.getKey(),entry.getValue());
                }
            }
            Request.Builder builder = new Request.Builder();
            if (MapUtils.isNotEmpty(headerMap)) {
                for (Map.Entry<String,String> entry : headerMap.entrySet()){
                    builder.addHeader(entry.getKey(),entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(multipartBodyPartDtoList)) {
                for (MultipartBodyPartDto multipartBodyPartDto : multipartBodyPartDtoList) {
                    multipartBodyBuilder.addPart(MultipartBody.Part.createFormData(multipartBodyPartDto.getName(), multipartBodyPartDto.getOriginalFilename(),
                            RequestBody.create(MediaType.parse("text/plain"), IOUtils.toByteArray(multipartBodyPartDto.getInputStream()))));
                }
            }
            RequestBody requestBody = multipartBodyBuilder.build();
            OkHttpClient okHttpClient = new OkHttpClient.Builder().
                    connectTimeout(500, TimeUnit.SECONDS).
                    writeTimeout(500, TimeUnit.SECONDS).
                    readTimeout(500, TimeUnit.SECONDS).
                    build();
            Request request = builder.url(url).post(requestBody).build();
            log.info("请求url:{},parameterMap:{}", url, parameterMap);
            Response response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                log.info("请求url:{},parameterMap:{},返回:{}",url,parameterMap,result);
                return result;
            }
            log.error("服务器端错误", response.message());
        } catch (IOException e) {
            log.error("请求遇到异常", e);
            throw new RuntimeException(e);
        }
        return null;
    }
}
