package com.chinamcloud.spider.utils;

import org.apache.commons.lang.StringUtils;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/2/16
 * Time: 下午1:31
 */
public class PathUtil {


    public static String builderPath(String... args) {
        String separator = "/";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; i++) {
            String backPart = args[i];
            if (i == 0) {
                stringBuilder.append(backPart);
                continue;
            }
            if(StringUtils.isEmpty(backPart)){
                continue;
            }
            String frontPart = stringBuilder.toString();
            if (frontPart.endsWith(separator) && !backPart.startsWith(separator)) {
                stringBuilder.append(backPart);
            } else if (frontPart.endsWith(separator) && backPart.startsWith(separator)) {
                stringBuilder.append(backPart.substring(1));
            }
            if (!frontPart.endsWith(separator) && !backPart.startsWith(separator)) {
                stringBuilder.append(separator).append(backPart);
            } else if (!frontPart.endsWith(separator) && backPart.startsWith(separator)) {
                stringBuilder.append(backPart);
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 拼接路径：以/为结尾,无参返回/
     * @param args
     * @return
     */
    public static String builderPathEndSlash(String... args) {
        String separator = "/";
        StringBuilder stringBuilder = new StringBuilder(builderPath(args));
        if(!stringBuilder.toString().endsWith(separator)){
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

}
