/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.base;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageRequest
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PageRequest.class);
    private Integer pageNumber = 1;
    private Integer pageSize = 10;
    private String orderField;
    private String orderDirection = "desc";

    public PageRequest() {
        this(1, 10);
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, "", "");
    }

    public PageRequest(int pageNumber, int pageSize, String orderField, String orderDirection) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.setOrderField(orderField);
        this.setOrderDirection(orderDirection);
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderDirection() {
        return this.orderDirection;
    }

    public void setOrderDirection(String orderDirection) {
        if (StringUtils.isNotBlank((String)orderDirection)) {
            String checkSQL = "\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)";
            Pattern pattern = Pattern.compile("\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)");
            Matcher matcher = pattern.matcher(orderDirection);
            if (matcher.find()) {
                log.error("\u975e\u6cd5\u8bf7\u6c42");
                throw new RuntimeException("\u975e\u6cd5\u8bf7\u6c42");
            }
        }
        this.orderDirection = orderDirection;
    }
}

