/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.guava2;

import com.chinamcloud.spider.guava2.Functions2;
import com.chinamcloud.spider.guava2.Identifiable;
import com.chinamcloud.spider.guava2.Maps2;
import com.chinamcloud.spider.guava2.Pair;
import com.chinamcloud.spider.guava2.SafeFunction;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class Lists2 {
    private Lists2() {
    }

    public static <K, V> List<V> newListFromKeyListAndValueMap(Collection<? extends K> ids, Map<? extends K, ? extends V> map) {
        ArrayList values = Lists.newArrayListWithCapacity((int)ids.size());
        for (K id : ids) {
            values.add(map.get(id));
        }
        return values;
    }

    public static <I, V extends Identifiable<I>> List<I> newIdList(Collection<? extends V> values) {
        return Lists2.transform(values, Functions2.newIdFunction());
    }

    public static <F, T> List<T> transform(Collection<F> fromList, Function<? super F, ? extends T> function) {
        Collection output = Collections2.transform(fromList, function);
        return Lists.newArrayList((Iterable)output);
    }

    public static <F, T> List<Pair<F, T>> transformToInOutPair(List<? extends F> fromList, Function<? super F, ? extends T> function) {
        Function<? super F, Pair<? super F, ? extends T>> fn = Functions2.newInAndOutFunction(function);
        List output = Lists.transform(fromList, fn);
        return Lists.newArrayList((Iterable)output);
    }

    public static <E> List<E> filter(List<E> unfiltered, Predicate<? super E> predicate) {
        Collection output = Collections2.filter(unfiltered, predicate);
        return Lists.newArrayList((Iterable)output);
    }

    public static <E> List<E> removeNull(List<E> unfiltered) {
        return Lists2.filter(unfiltered, Predicates.notNull());
    }

    public static <T> List<T> page(List<T> list, int offset, int count) {
        int fromIndex = Math.min(offset, list.size());
        int toIndex = Math.min(offset + count, list.size());
        return Lists.newArrayList(list.subList(fromIndex, toIndex));
    }

    public static <U, V> List<Pair<U, V>> zip(List<? extends U> list1, List<? extends V> list2) throws IllegalArgumentException {
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            throw new IllegalArgumentException("Two list must have the same size");
        }
        ArrayList results = Lists.newArrayListWithCapacity((int)list1.size());
        for (int i = 0; i < list1.size(); ++i) {
            Pair<U, V> pair = Pair.of(list1.get(i), list2.get(i));
            results.add(pair);
        }
        return results;
    }

    public static <U extends Identifiable<I>, V extends Identifiable<I>, I> List<Pair<U, V>> zipWithSameIdList(List<? extends U> list1, List<? extends V> list2) {
        return Lists2.zipWithMap(list1, Maps2.newIdToValueMap(list2));
    }

    public static <U extends Identifiable<K>, V, K> List<Pair<U, V>> zipWithSameKeyList(List<U> list1, List<V> list2, Function<V, K> keyFn2) {
        return Lists2.zipWithMap(list1, Maps2.newMapWithValue(list2, keyFn2));
    }

    public static <U extends Identifiable<I>, V, I> List<Pair<U, V>> zipWithMap(List<? extends U> list, final Map<? extends I, ? extends V> map) {
        return Lists2.transformToInOutPair(list, new SafeFunction<U, V>(){

            @Override
            public V safeApply(U input) {
                return map.get(input.getIdentify());
            }
        });
    }
}

