/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.utils;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.spider.dto.InterfaceDto;
import com.chinamcloud.spider.dto.MultipartBodyPartDto;
import com.chinamcloud.spider.utils.OkHttpUtil2;
import com.chinamcloud.spider.utils.PathUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Headers;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    public static String getValue(HttpServletRequest request, String key) {
        return request.getHeader(key) != null ? request.getHeader(key) : request.getParameter(key);
    }

    public static List<MultipartBodyPartDto> getMultipartBodyPartDtoList(HttpServletRequest request) throws IOException {
        MultiValueMap multiFileMap = ((MultipartHttpServletRequest)request).getMultiFileMap();
        if (MapUtils.isEmpty((Map)multiFileMap)) {
            return Lists.newArrayList();
        }
        ArrayList multipartBodyPartDtoList = Lists.newArrayList();
        for (Map.Entry entry : multiFileMap.entrySet()) {
            List multipartFileList = (List)entry.getValue();
            for (MultipartFile multipartFile : multipartFileList) {
                MultipartBodyPartDto multipartBodyPartDto = new MultipartBodyPartDto();
                multipartBodyPartDto.setName(multipartFile.getName());
                multipartBodyPartDto.setOriginalFilename(multipartFile.getOriginalFilename());
                multipartBodyPartDto.setInputStream(multipartFile.getInputStream());
                multipartBodyPartDtoList.add(multipartBodyPartDto);
            }
        }
        return multipartBodyPartDtoList;
    }

    public static void forward(HttpServletRequest request, HttpServletResponse response, String domainUrl, String servletPath, RequestMethod requestMethod) {
        try {
            Response result;
            Headers headers;
            InterfaceDto interfaceDto = new InterfaceDto();
            interfaceDto.setUrl(PathUtil.builderPath(domainUrl, (String)MoreObjects.firstNonNull((Object)servletPath, (Object)request.getServletPath())));
            Map<String, String> headerMap = RequestUtil.buildRequestHeaders(request);
            if (!StringUtils.isEmpty((Object)request.getContentType())) {
                headerMap.put("contentType", request.getContentType());
            }
            if (requestMethod != null) {
                headerMap.put("method", requestMethod.name());
            }
            interfaceDto.setHeaderMap(headerMap);
            Map<String, Object> paramMap = RequestUtil.buildRequestQueryParams(request);
            interfaceDto.setParameterMap(paramMap);
            if (request instanceof MultipartHttpServletRequest) {
                List<MultipartBodyPartDto> multipartBodyPartDtoList = RequestUtil.getMultipartBodyPartDtoList(request);
                interfaceDto.setMultipartBodyPartDtoList(multipartBodyPartDtoList);
            }
            if ((headers = (result = OkHttpUtil2.execute(interfaceDto)).headers()) != null) {
                Set names = headers.names();
                for (String name : names) {
                    response.addHeader(name, headers.get(name));
                }
            }
            response.setStatus(result.code());
            response.getWriter().write(result.body().string());
        }
        catch (Exception e) {
            log.error("\u8f6c\u53d1\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Map<String, String> buildRequestHeaders(HttpServletRequest request) {
        HashMap headerMap = Maps.newHashMap();
        Enumeration enumeration = request.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if ("content-length".equalsIgnoreCase(name)) continue;
                headerMap.put(name, request.getHeader(name));
            }
        }
        return headerMap;
    }

    private static Map<String, Object> buildRequestQueryParams(HttpServletRequest request) {
        Map<String, Object> queryParamsMap = RequestUtil.getQueryParams(request);
        Enumeration enumeration = request.getParameterNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                queryParamsMap.put(name, request.getParameter(name));
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String inputStr = null;
            while ((inputStr = bufferedReader.readLine()) != null) {
                stringBuilder.append(inputStr);
            }
            String jsonString = stringBuilder.toString();
            if (!StringUtils.isEmpty((Object)jsonString)) {
                queryParamsMap.putAll((Map<String, Object>)JSONObject.parseObject((String)jsonString));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return queryParamsMap;
    }

    private static Map<String, Object> getQueryParams(HttpServletRequest request) {
        HashMap qp = Maps.newHashMap();
        if (request.getQueryString() == null) {
            return qp;
        }
        StringTokenizer st = new StringTokenizer(request.getQueryString(), "&");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i > 0 && s.length() >= i + 1) {
                name = s.substring(0, i);
                value = s.substring(i + 1);
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                qp.put(name, value);
                continue;
            }
            if (i != -1) continue;
            name = s;
            value = "";
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            qp.put(name, value);
        }
        return qp;
    }
}

