/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.cache.config;

import com.chinamcloud.spider.cache.component.CacheEventHandler;
import com.chinamcloud.spider.cache.component.impl.DefaultCacheEventHandler;
import com.chinamcloud.spider.cache.component.impl.SpiderCacheManager;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@EnableCaching
@ComponentScan(basePackages={"com.chinamcloud.spider.cache"})
public class SpiderCacheConfig {
    @Autowired
    private RedisConnectionFactory jedisConnectionFactory;
    @Value(value="${spring.application.name:cache_event_channel}")
    private String channel = "cache_event_channel";
    @Value(value="${spring.redis.defaultExpiration:86400}")
    private Long redisDefaultExpiration = 86400L;

    @Bean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(this.jedisConnectionFactory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    public RedisCacheManager redisCacheManager() {
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.jedisConnectionFactory);
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig();
        defaultCacheConfig.entryTtl(Duration.ofMillis(this.redisDefaultExpiration));
        return new RedisCacheManager(redisCacheWriter, defaultCacheConfig);
    }

    @Bean
    public EhCacheManagerFactoryBean cacheManagerFactory() {
        EhCacheManagerFactoryBean ehCacheManagerFactoryBean = new EhCacheManagerFactoryBean();
        ehCacheManagerFactoryBean.setConfigLocation((Resource)new ClassPathResource("ehcache.xml"));
        return ehCacheManagerFactoryBean;
    }

    @Bean
    public EhCacheCacheManager ehCacheCacheManager() {
        EhCacheCacheManager ehCacheCacheManager = new EhCacheCacheManager(this.cacheManagerFactory().getObject());
        return ehCacheCacheManager;
    }

    @Bean
    public CacheEventHandler cacheEventHandler() {
        DefaultCacheEventHandler defaultCacheEventHandler = new DefaultCacheEventHandler();
        defaultCacheEventHandler.setLocalCacheManager((CacheManager)this.ehCacheCacheManager());
        defaultCacheEventHandler.setRedisTemplate(this.redisTemplate());
        defaultCacheEventHandler.setChannel(this.channel);
        MessageListenerAdapter listener = new MessageListenerAdapter((Object)defaultCacheEventHandler);
        listener.setSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
        listener.afterPropertiesSet();
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(this.jedisConnectionFactory);
        container.addMessageListener((MessageListener)listener, (Topic)new ChannelTopic(this.channel));
        container.afterPropertiesSet();
        container.start();
        return defaultCacheEventHandler;
    }

    @Bean
    @Primary
    public CacheManager cacheManager() {
        SpiderCacheManager spiderCacheManager = new SpiderCacheManager();
        spiderCacheManager.setLocalCacheManager((CacheManager)this.ehCacheCacheManager());
        spiderCacheManager.setRemoteCacheManager((CacheManager)this.redisCacheManager());
        spiderCacheManager.setCacheEventHandler(this.cacheEventHandler());
        return spiderCacheManager;
    }
}

