/*
 * Copyright(c) 2017 chinamcloud.com All rights reserved.
 * http://www.chinamcloud.com/
 */
package com.chinamcloud.spider.model;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * ModuleId
 * @version 1.0
 * @author
 */
@Setter
@Getter
public class ModuleId {

	//主键Id
	private Long moduleId;

	//模块名称
	@NotBlank
	@Length(max=64)
	private String moduleName;

	//不同模块编号
	@NotNull
	private Long moduleNumber;

	//同组模块编号
	@NotNull 
	private Long memberNumber;

	//创建时间
	private Date createTime;

	//更新时间
	private Date updateTime;


}
