/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config;

import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.util.StringUtils;
import com.chinamcloud.spider.system.config.dbinterceptors.DMKeywordInterceptor;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
@ComponentScan(basePackages={"com.chinamcloud.spider"})
public class DataSourceAutoConfiguration {
    @Value(value="${spring.druid.datasource.type}")
    private String type;
    @Value(value="${spring.druid.datasource.driverClassName}")
    private String driverClassName;
    @Value(value="${spring.druid.datasource.url}")
    private String url;
    @Value(value="${spring.druid.datasource.username}")
    private String username;
    @Value(value="${spring.druid.datasource.password}")
    private String password;
    @Value(value="${spring.druid.datasource.initialSize}")
    private Integer initialSize;
    @Value(value="${spring.druid.datasource.minIdle}")
    private Integer minIdle;
    @Value(value="${spring.druid.datasource.maxActive}")
    private Integer maxActive;
    @Value(value="${spring.druid.datasource.maxWait}")
    private Long maxWait;
    @Value(value="${spring.druid.datasource.timeBetweenEvictionRunsMillis}")
    private Long timeBetweenEvictionRunsMillis;
    @Value(value="${spring.druid.datasource.minEvictableIdleTimeMillis}")
    private Long minEvictableIdleTimeMillis;
    @Value(value="${spring.druid.datasource.validationQuery}")
    private String validationQuery;
    @Value(value="${spring.druid.datasource.testWhileIdle}")
    private boolean testWhileIdle;
    @Value(value="${spring.druid.datasource.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${spring.druid.datasource.testOnReturn}")
    private boolean testOnReturn;
    @Value(value="${spring.druid.datasource.poolPreparedStatements}")
    private boolean poolPreparedStatements;
    @Value(value="${spring.druid.datasource.maxPoolPreparedStatementPerConnectionSize}")
    private Integer maxPoolPreparedStatementPerConnectionSize;
    @Value(value="${spring.druid.datasource.filters}")
    private String filters;
    @Value(value="${spring.druid.datasource.connectionProperties}")
    private String connectionProperties;
    @Value(value="${spring.druid.datasource.useGlobalDataSourceStat:false}")
    private boolean useGlobalDataSourceStat;
    private String mapperPath = "**/*Mapper.xml";

    @Bean(value={"spiderDruidDataSource"})
    public DruidDataSource dataSource() throws Exception {
        String driverClassNameFinal;
        DruidDataSource dataSource = new DruidDataSource();
        Pattern pattern = Pattern.compile("jdbc:(\\w+)://.*?/([^?]+)");
        Matcher matcher = pattern.matcher(this.url);
        if (matcher.find()) {
            String jdbcType = matcher.group(1);
            String dbName = matcher.group(2);
            driverClassNameFinal = this.driverClassName;
            if (StringUtils.equalsIgnoreCase((String)jdbcType, (String)"dm")) {
                dataSource.setConnectionInitSqls((Collection)Lists.newArrayList((Object[])new String[]{"SET SCHEMA " + dbName + ";"}));
                if (StringUtils.isEmpty((CharSequence)this.driverClassName)) {
                    driverClassNameFinal = "dm.jdbc.driver.DmDriver";
                }
            } else {
                dataSource.setConnectionInitSqls((Collection)Lists.newArrayList((Object[])new String[]{"set names utf8mb4;"}));
                if (StringUtils.isEmpty((CharSequence)this.driverClassName)) {
                    driverClassNameFinal = "com.mysql.jdbc.Driver";
                }
            }
        } else {
            System.out.println("Invalid JDBC URL.:" + this.url);
            throw new IllegalArgumentException("\u65e0\u6548\u7684jdbc\u8fde\u63a5\u4fe1\u606f:" + this.url);
        }
        dataSource.setDriverClassName(driverClassNameFinal);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        dataSource.setInitialSize(this.initialSize.intValue());
        dataSource.setMinIdle(this.minIdle.intValue());
        dataSource.setMaxActive(this.maxActive.intValue());
        dataSource.setMaxWait(this.maxWait.longValue());
        dataSource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis.longValue());
        dataSource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis.longValue());
        if (this.validationQuery != null && !"".equals(this.validationQuery)) {
            dataSource.setValidationQuery(this.validationQuery);
        }
        dataSource.setTestWhileIdle(this.testWhileIdle);
        dataSource.setTestOnBorrow(this.testOnBorrow);
        dataSource.setTestOnReturn(this.testOnReturn);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize.intValue());
        try {
            dataSource.setFilters(this.filters);
        }
        catch (SQLException e) {
            System.err.println("\u8bbe\u7f6e\u6570\u636e\u6e90\u8fc7\u6ee4\u5668\u51fa\u9519:" + this.url);
        }
        if (this.connectionProperties != null && !"".equals(this.connectionProperties)) {
            String[] propertiesList;
            Properties connectProperties = new Properties();
            for (String propertiesTmp : propertiesList = this.connectionProperties.split(";")) {
                String[] obj = propertiesTmp.split("=");
                String key = obj[0];
                String value = obj[1];
                connectProperties.put(key, value);
            }
            dataSource.setConnectProperties(connectProperties);
        }
        dataSource.getProxyFilters().add(this.slf4jLogFilter());
        dataSource.setUseGlobalDataSourceStat(this.useGlobalDataSourceStat);
        return dataSource;
    }

    @Bean(name={"spiderSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean(@Qualifier(value="spiderDruidDataSource") DruidDataSource druidDataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource((DataSource)druidDataSource);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources("classpath*:" + this.mapperPath));
        sqlSessionFactoryBean.setConfigLocation((Resource)new ClassPathResource("mybatis-config.xml"));
        sqlSessionFactoryBean.setPlugins(DataSourceAutoConfiguration.createInterceptors(druidDataSource));
        return sqlSessionFactoryBean.getObject();
    }

    private static Interceptor[] createInterceptors(DruidDataSource dataSource) {
        String driverClassName;
        if (dataSource != null && (driverClassName = dataSource.getDriverClassName()).contains("dm")) {
            return new Interceptor[]{new DMKeywordInterceptor()};
        }
        return new Interceptor[0];
    }

    @Bean(value={"spiderDataSourceTransactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="spiderDruidDataSource") DruidDataSource druidDataSource) throws Exception {
        return new DataSourceTransactionManager((DataSource)druidDataSource);
    }

    @Bean
    public Slf4jLogFilter slf4jLogFilter() {
        Slf4jLogFilter slf4jLogFilter = new Slf4jLogFilter();
        slf4jLogFilter.setStatementExecutableSqlLogEnable(true);
        slf4jLogFilter.setConnectionLogEnabled(true);
        slf4jLogFilter.setResultSetLogErrorEnabled(true);
        slf4jLogFilter.setStatementLogEnabled(true);
        return slf4jLogFilter;
    }

    @Bean(name={"spiderSqlSessionTemplate"})
    public SqlSessionTemplate SqlSessionTemplate(@Qualifier(value="spiderSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxWait(Long maxWait) {
        this.maxWait = maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(Integer maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setUseGlobalDataSourceStat(boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
    }

    public void setMapperPath(String mapperPath) {
        this.mapperPath = mapperPath;
    }

    public String getType() {
        return this.type;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public Long getMaxWait() {
        return this.maxWait;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public Integer getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public String getFilters() {
        return this.filters;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public boolean isUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public String getMapperPath() {
        return this.mapperPath;
    }
}

