/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors;

import com.alibaba.druid.util.StringUtils;
import com.chinamcloud.spider.system.config.dbinterceptors.DynamicBoundSql;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DMKeywordInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameterObject = null;
        if (invocation.getArgs().length > 1) {
            parameterObject = invocation.getArgs()[1];
        }
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        String sqlOld = boundSql.getSql();
        final BoundSql boundSqlUpdate = this.processSql(boundSql, invocation);
        if (!StringUtils.equalsIgnoreCase((String)boundSqlUpdate.getSql(), (String)sqlOld)) {
            Class<?> mappedStatementClass = mappedStatement.getClass();
            Field sqlSourceField = mappedStatementClass.getDeclaredField("sqlSource");
            sqlSourceField.setAccessible(true);
            sqlSourceField.set(mappedStatement, new SqlSource(){

                public BoundSql getBoundSql(Object parameterObjectParam) {
                    return boundSqlUpdate;
                }
            });
        }
        return invocation.proceed();
    }

    private BoundSql processSql(BoundSql boundSql, Invocation invocation) {
        ProcessTokenEnum[] values = ProcessTokenEnum.values();
        DynamicBoundSql dynamicSqlBound = boundSql instanceof DynamicBoundSql ? (DynamicBoundSql)boundSql : DynamicBoundSql.getDynamicSqlBound(boundSql);
        for (ProcessTokenEnum value : values) {
            if (!value.shouldProcess(dynamicSqlBound, invocation)) continue;
            dynamicSqlBound = value.process(dynamicSqlBound, invocation);
        }
        return dynamicSqlBound;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static enum ProcessTokenEnum {
        KEYWORD{
            final String[] targetToken = new String[]{"comment"};

            @Override
            protected boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
                String lowerSql = originSql.getSql().toLowerCase();
                for (String token : this.targetToken) {
                    if (!lowerSql.contains(token)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
                String processSql = oldSql.getSql();
                for (String s : this.targetToken) {
                    processSql = processSql.replaceAll("(?<=[\\s,])+" + s + "(?=[\\s,])+", "\"" + s + "\"");
                }
                oldSql.setSql(processSql);
                return oldSql;
            }
        }
        ,
        SUBDATE,
        GROUP_BY{
            private final String COMPATIBILITY_IDENTIFICATION = "/*+ GROUP_OPT_FLAG(1)*/";

            @Override
            protected boolean shouldProcess(DynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String originSql2 = dynamicSqlBound.getSqlOriginal().replace(" ", "");
                return (originSql2 = originSql2.toLowerCase()).contains("groupby") && !originSql2.contains("/*+ GROUP_OPT_FLAG(1)*/".toLowerCase());
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql dynamicSqlBound, Invocation invocation) {
                String sqlNew = dynamicSqlBound.getSql().replaceFirst("(?i)(?<=select)[^aA]*?(?=from)", " /*+ GROUP_OPT_FLAG(1)*/ $0");
                dynamicSqlBound.setSql(sqlNew);
                return dynamicSqlBound;
            }
        }
        ,
        INSERT_PK{

            @Override
            protected boolean shouldProcess(DynamicBoundSql oldSql, Invocation invocation) {
                String lowerSql = oldSql.getSql().toLowerCase();
                Object arg0 = invocation.getArgs()[0];
                if (!(arg0 instanceof MappedStatement)) {
                    return false;
                }
                MappedStatement statement = (MappedStatement)arg0;
                return statement.getSqlCommandType() == SqlCommandType.INSERT && lowerSql.contains("id") && !lowerSql.contains("identity_insert");
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSqlBound, Invocation invocation) {
                MappedStatement statement;
                String id;
                Object arg0;
                String sqlOld = oldSqlBound.getSql();
                Pattern pattern = Pattern.compile("(?i)insert\\s+into\\s+(\\S+)\\s+");
                Matcher matcher = pattern.matcher(sqlOld);
                String tableName = "";
                if (matcher.find()) {
                    tableName = matcher.group(1);
                }
                if (StringUtils.isEmpty((CharSequence)tableName)) {
                    System.err.println("\u6ca1\u6709\u5339\u914d\u5230\u8868\u540d:" + sqlOld);
                    return oldSqlBound;
                }
                String insertBefore = "set IDENTITY_INSERT " + tableName + " ON;\n";
                String insertAfter = "set IDENTITY_INSERT " + tableName + " OFF\n";
                if (!sqlOld.endsWith(";")) {
                    sqlOld = sqlOld + ";";
                }
                if ((arg0 = invocation.getArgs()[0]) instanceof MappedStatement && (id = (statement = (MappedStatement)arg0).getId()).endsWith("inserts")) {
                    String mapperNameSpace = id.substring(0, id.lastIndexOf("."));
                    Object arg1 = invocation.getArgs()[1];
                    if (arg1 instanceof Map) {
                        ResultMapping idResultMap;
                        List idResultMappings;
                        Map resultMaps;
                        ResultMap baseResultMap;
                        Map arg1Map = (Map)arg1;
                        List entities = (List)arg1Map.get("list");
                        if (entities == null) {
                            entities = (List)arg1Map.get("collection");
                        }
                        if (entities != null && !entities.isEmpty() && (baseResultMap = (ResultMap)(resultMaps = ProcessTokenEnum.getResultMaps(invocation)).get(mapperNameSpace + ".BaseResultMap")) != null && (idResultMappings = baseResultMap.getIdResultMappings()) != null && !idResultMappings.isEmpty() && (idResultMap = (ResultMapping)idResultMappings.get(0)) != null) {
                            int size = entities.size();
                            boolean isAnyNullPK = false;
                            Field idField = baseResultMap.getType().getDeclaredField(idResultMap.getProperty());
                            idField.setAccessible(true);
                            for (int i = 1; i <= size; ++i) {
                                boolean nullPk;
                                Object column_id = idField.get(entities.get(i - 1));
                                boolean bl = nullPk = column_id == null;
                                if (!(isAnyNullPK |= nullPk)) continue;
                                idField.set(entities.get(i - 1), null);
                            }
                            idField.setAccessible(false);
                            Pattern patternValues = Pattern.compile("(?i)\\s*\\([^)]+\\)(?!\\s*values)");
                            Matcher matcherValue = patternValues.matcher(sqlOld);
                            ArrayList<String> values = new ArrayList<String>();
                            while (matcherValue.find()) {
                                values.add(matcherValue.group());
                            }
                            if (isAnyNullPK) {
                                sqlOld = this.delOneColumn(sqlOld, idResultMap, values);
                                List<ParameterMapping> parameterMappings = oldSqlBound.getParameterMappings();
                                LinkedList<ParameterMapping> parameterMappingsNew = new LinkedList<ParameterMapping>();
                                for (ParameterMapping parameterMapping : parameterMappings) {
                                    String property = parameterMapping.getProperty();
                                    String actProperty = property.substring(property.lastIndexOf(".") + 1);
                                    if (idResultMap.getProperty().equalsIgnoreCase(actProperty)) continue;
                                    parameterMappingsNew.add(parameterMapping);
                                }
                                oldSqlBound.setParameterMappings(parameterMappingsNew);
                            }
                        }
                    }
                }
                oldSqlBound.setSql(insertBefore + (sqlOld.endsWith(";") ? sqlOld : sqlOld + ";") + insertAfter);
                return oldSqlBound;
            }

            private String delOneColumn(String sqlOld, ResultMapping idResultMap, ArrayList<String> values) {
                sqlOld = sqlOld.replaceFirst(idResultMap.getColumn() + ",", "");
                String[] split = sqlOld.split("(?i)values");
                String sql1 = split[0];
                StringBuilder builder = new StringBuilder();
                builder.append(sql1);
                builder.append(" values ");
                for (int i = 0; i < values.size(); ++i) {
                    String item = values.get(i).replaceFirst("\\?\\s*,", "");
                    if (i != values.size() - 1) {
                        item = item + ",";
                    }
                    builder.append(item);
                }
                sqlOld = builder.toString();
                return sqlOld;
            }
        }
        ,
        GROUP_COUNT{

            @Override
            protected boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
                String lowerSql = originSql.getSql().toLowerCase();
                return lowerSql.contains("group_concat(");
            }

            @Override
            public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
                String sql = oldSql.getSql();
                String funcOld = "(?i)" + this.name() + "\\(";
                String funcNew = "WM_CONCAT\\(";
                sql = sql.replaceAll(funcOld, funcNew);
                oldSql.setSql(sql);
                return oldSql;
            }
        };

        private static volatile Map<String, ResultMap> resultMaps;

        protected boolean shouldProcess(DynamicBoundSql originSql, Invocation invocation) {
            return false;
        }

        public DynamicBoundSql process(DynamicBoundSql oldSql, Invocation invocation) {
            return oldSql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Map<String, ResultMap> getResultMaps(Invocation invocation) {
            if (resultMaps != null) return resultMaps;
            Class<DMKeywordInterceptor> clazz = DMKeywordInterceptor.class;
            synchronized (DMKeywordInterceptor.class) {
                if (resultMaps != null) return resultMaps;
                MappedStatement arg0 = (MappedStatement)invocation.getArgs()[0];
                Configuration configuration = arg0.getConfiguration();
                Field resultMapField = Configuration.class.getDeclaredField("resultMaps");
                resultMapField.setAccessible(true);
                resultMaps = (Map)resultMapField.get(configuration);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return resultMaps;
            }
        }
    }
}

