package com.chinamcloud.spider.listener;

import cn.ms.sequence.Sequence;
import com.chinamcloud.spider.dao.ModuleIdMapper;
import com.chinamcloud.spider.model.ModuleId;
import com.chinamcloud.spider.ordering.ModuleIdByModuleNumberOrdering;
import com.chinamcloud.spider.utils.IdUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 17/7/4
 * Time: 下午3:11
 */
@Slf4j
@Component
public class ModelIdStartupListener implements ApplicationListener<ContextRefreshedEvent> {

    @Value("${spring.application.name}")
    private String applicationName;

    @Autowired
    private IdUtil idUtil;

    @Autowired
    private ModuleIdMapper moduleIdMapper;

    @Override
    @Transactional
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        log.info("begin init IdUtil moduleNumber and memberNumber");
        if (StringUtils.isBlank(applicationName)) {
            log.error("spring.application.name is blank ");
            throw new RuntimeException("spring.application.name is blank ");
        }
        List<ModuleId> moduleIdList = moduleIdMapper.findAll();
        ModuleId moduleIdModel = getModuleIdModel(moduleIdList);
        Long moduleNumber = 0L, memberNumber = 0L;
        if (moduleIdModel == null) {
            moduleNumber = getCurrentModuleNumber(moduleIdList);
            insert(moduleNumber, memberNumber);
        } else {
            moduleNumber = moduleIdModel.getModuleNumber();
            memberNumber = moduleIdModel.getMemberNumber() + 1;
            updateMemberNumber(moduleIdModel.getModuleId());
        }
        long moldNumber = 32;
        Sequence sequence = new Sequence(moduleNumber % moldNumber, memberNumber % moldNumber);
        idUtil.setSequence(sequence);
        log.info("end init IdUtil moduleNumber and memberNumber");
    }

    private void insert(Long moduleNumber, long memberNumber) {
        ModuleId moduleIdModel = new ModuleId();
        moduleIdModel.setModuleName(applicationName);
        moduleIdModel.setModuleNumber(moduleNumber);
        moduleIdModel.setMemberNumber(memberNumber);
        Date date = new Date();
        moduleIdModel.setCreateTime(date);
        moduleIdModel.setUpdateTime(date);
        moduleIdMapper.save(moduleIdModel);
    }

    private long getCurrentModuleNumber(List<ModuleId> moduleIdList) {
        if (CollectionUtils.isEmpty(moduleIdList)) {
            return 0L;
        }
        Collections.sort(moduleIdList, ModuleIdByModuleNumberOrdering.INSTANCE);
        return moduleIdList.get(moduleIdList.size()-1).getModuleNumber() + 1;
    }

    private ModuleId getModuleIdModel(List<ModuleId> moduleIdList) {
        if (CollectionUtils.isEmpty(moduleIdList)) {
            return null;
        }
        for (ModuleId moduleId : moduleIdList){
            if (moduleId.getModuleName().equals(applicationName)){
                return moduleId;
            }
        }
        return null;
    }

    private void updateMemberNumber(long moduleId) {
        Map<String, Object> parameterMap = Maps.newHashMap();
        parameterMap.put("moduleId", moduleId);
        parameterMap.put("updateTime", new Date());
        moduleIdMapper.updateBySql("updateMemberId", parameterMap);
    }
}
