package com.chinamcloud.spider.ordering;

import com.chinamcloud.spider.model.ModuleId;
import com.google.common.collect.Ordering;

/**
 * Created with IntelliJ IDEA.
 * User: chenzhiwei
 * Date: 18/1/16
 * Time: 下午1:06
 */
public final class ModuleIdByModuleNumberOrdering extends Ordering<ModuleId> {

    public static final ModuleIdByModuleNumberOrdering INSTANCE = new ModuleIdByModuleNumberOrdering();

    @Override
    public int compare(ModuleId left, ModuleId right) {
        return left.getModuleNumber().compareTo(right.getModuleNumber());
    }

    private ModuleIdByModuleNumberOrdering() {
    }
}