package com.chinamcloud.spider.system.config.dbinterceptors.dm;

import com.alibaba.druid.util.StringUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.SneakyThrows;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

@Setter
@Getter
public class DynamicBoundSql extends BoundSql {
    /**
     * sql代理
     */
    private String sql;
    /**
     * 映射参数代理
     */
    private List<ParameterMapping> parameterMappings;
    /**
     * 代理参数
     */
    public Object parameterObject;
    private Map<String, Object> additionalParameters;
    private MetaObject metaParameters;

    public DynamicBoundSql(Configuration configuration, String sql, List<ParameterMapping> parameterMappings, Object parameterObject) {
        super(configuration, sql, parameterMappings, parameterObject);
    }

    @SneakyThrows
    @SuppressWarnings("unchecked")
    public static DynamicBoundSql getDynamicSqlBound(final BoundSql boundSql) {
        final Field metaParameters = BoundSql.class.getDeclaredField("metaParameters");
        final Field additionalParameters = BoundSql.class.getDeclaredField("additionalParameters");
        metaParameters.setAccessible(true);
        additionalParameters.setAccessible(true);
        final MetaObject metaObject = (MetaObject) metaParameters.get(boundSql);
        final Map<String, Object> additionalParametersObject = (Map<String, Object>) additionalParameters.get(boundSql);
        DynamicBoundSql dyBoundSql = new DynamicBoundSql(new Configuration() {
            @Override
            public MetaObject newMetaObject(Object object) {
                return metaObject;
            }
        }, boundSql.getSql(), boundSql.getParameterMappings(), boundSql.getParameterObject());
        dyBoundSql.setSql(boundSql.getSql());
        dyBoundSql.setParameterMappings(boundSql.getParameterMappings());
        dyBoundSql.setParameterObject(boundSql.getParameterObject());
        dyBoundSql.setMetaParameters(metaObject);
        dyBoundSql.setAdditionalParameters(additionalParametersObject);
        return dyBoundSql;
    }

    @Override
    public String getSql() {
        if (StringUtils.isEmpty(sql)) {
            return super.getSql();
        }
        return sql;
    }

    @Override
    public List<ParameterMapping> getParameterMappings() {
        return parameterMappings;
    }

    @Override
    public Object getParameterObject() {
        return parameterObject;
    }

    public boolean hasAdditionalParameter(String name) {
        String paramName = new PropertyTokenizer(name).getName();
        return additionalParameters.containsKey(paramName);
    }

    public void setAdditionalParameter(String name, Object value) {
        metaParameters.setValue(name, value);
    }

    public Object getAdditionalParameter(String name) {
        return metaParameters.getValue(name);
    }
}