/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.base;

import com.chinamcloud.spider.base.DBDriverAdapter;
import com.chinamcloud.spider.base.EntityDao;
import com.chinamcloud.spider.base.PageRequest;
import com.chinamcloud.spider.base.PageResult;
import com.chinamcloud.spider.exception.DataAccessException;
import com.chinamcloud.spider.exception.SpiderException;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.mapping.ResultMapping;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public abstract class BaseDao<E, PK extends Serializable>
implements EntityDao<E, PK> {
    private static final Logger log = LoggerFactory.getLogger(BaseDao.class);
    @Autowired
    @Qualifier(value="spiderSqlSessionTemplate")
    protected SqlSessionTemplate sqlSessionTemplate;
    private static final DBDriverAdapter DBDA = new DBDriverAdapter();

    @Override
    public int save(E entity) {
        log.debug("--------->\u4fdd\u5b58\u5bf9\u8c61 : " + entity);
        return this.sqlSessionTemplate.insert(this.getInsertStatement(), entity);
    }

    @Override
    public void batchSave(List<E> entities) throws DataAccessException {
        if (CollectionUtils.isEmpty(entities)) {
            log.error("\u6279\u91cf\u4fdd\u5b58\u53c2\u6570\u4f20\u9012\u9519\u8bef");
            throw new RuntimeException("\u6279\u91cf\u4fdd\u5b58\u53c2\u6570\u4f20\u9012\u9519\u8bef:entities\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("--------->\u6279\u91cf\u4fdd\u5b58\u5bf9\u8c61 : " + entities);
        this.sqlSessionTemplate.insert(this.getBatchInsertStatement(), entities);
    }

    @Override
    public void saveOrUpdate(PK primaryKey, E entity) throws DataAccessException {
        boolean isNull;
        if (primaryKey instanceof CharSequence) {
            isNull = StringUtils.isEmpty(primaryKey);
        } else {
            boolean bl = isNull = primaryKey == null;
        }
        if (isNull || this.getById(primaryKey) == null) {
            this.save(entity);
        } else {
            this.updateById(entity);
        }
    }

    @Override
    public PageResult findPage(PageRequest pageRequest) {
        try {
            return BaseDao.pageQuery(this.sqlSessionTemplate, this.getPageStatementForPaging(), this.getCountStatementForPaging(), pageRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataAccessException("\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
    }

    public static PageResult pageQuery(SqlSessionTemplate sqlSessionTemplate, String statementName, String countStatementName, PageRequest pageRequest) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        PageResult pageResult = new PageResult(pageRequest.getPageNumber().intValue(), pageRequest.getPageSize().intValue());
        Number totalCount = (Number)sqlSessionTemplate.selectOne(countStatementName, (Object)PropertyUtils.describe((Object)pageRequest));
        pageResult.setTotalRecords(totalCount == null ? 0 : totalCount.intValue());
        pageResult.setOrderField(pageRequest.getOrderField());
        pageResult.setOrderDirection(pageRequest.getOrderDirection());
        log.debug("---------------> : \u4e00\u5171{}\u6570\u636e ", (Object)totalCount);
        if (totalCount != null && totalCount.longValue() > 0L) {
            HashMap<String, Object> filters = new HashMap<String, Object>(16);
            filters.put("offset", pageResult.getStartRecord());
            filters.put("pageSize", pageResult.getPageSize());
            filters.put("pageS", DBDA.getPageS("MySql"));
            filters.put("pageE", DBDA.getPageE("MySql"));
            Map parameterObject = PropertyUtils.describe((Object)pageRequest);
            filters.putAll(parameterObject);
            String orderField = BaseDao.getOrderField(sqlSessionTemplate, pageResult.getOrderField(), statementName);
            filters.put("orderField", orderField);
            String orderDirection = pageResult.getOrderDirection();
            BaseDao.checkOrderDirection(orderDirection);
            filters.put("orderDirection", orderDirection);
            List list = sqlSessionTemplate.selectList(statementName, filters);
            if (!list.isEmpty()) {
                pageResult.setPageRecords(list);
            }
        }
        return pageResult;
    }

    private static void checkOrderDirection(String orderDirection) {
        if (!(StringUtils.isEmpty((Object)orderDirection) || (orderDirection = orderDirection.trim()).equalsIgnoreCase("desc") || orderDirection.equalsIgnoreCase("asc"))) {
            throw new SpiderException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6392\u5e8f\u89c4\u5219");
        }
    }

    private static String getOrderField(SqlSessionTemplate sqlSessionTemplate, String orderField, String statementName) {
        if (StringUtils.isEmpty((Object)orderField)) {
            return null;
        }
        String replaceOrderField = null;
        String nameSpace = statementName.substring(0, statementName.lastIndexOf("."));
        List resultMappingList = sqlSessionTemplate.getConfiguration().getResultMap(nameSpace + ".BaseResultMap").getResultMappings();
        HashMap columnMap = Maps.newHashMapWithExpectedSize((int)(resultMappingList.size() * 2));
        for (ResultMapping resultMapping : resultMappingList) {
            columnMap.put(resultMapping.getProperty().toLowerCase(), resultMapping.getColumn());
            columnMap.put(resultMapping.getColumn().toLowerCase(), resultMapping.getColumn());
        }
        String[] fieldArray = orderField.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        for (String field : fieldArray) {
            if ((field = field.trim()).contains(" ")) {
                String[] subField = field.split(" ");
                BaseDao.checkOrderField(subField[0].trim(), columnMap, stringBuffer);
                String orderDirection = subField[1].trim();
                BaseDao.checkOrderDirection(orderDirection);
                stringBuffer.append(" ").append(orderDirection).append(",");
                continue;
            }
            BaseDao.checkOrderField(field, columnMap, stringBuffer);
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 1) {
            replaceOrderField = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        }
        return replaceOrderField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkOrderField(String field, Map<String, String> columnMap, StringBuffer stringBuffer) {
        String fieldLower = field.toLowerCase();
        Set<String> columnSet = columnMap.keySet();
        if (fieldLower.contains(".")) {
            String orderField = fieldLower.split("\\.")[1];
            if (!columnSet.contains(orderField)) throw new SpiderException("\u5b58\u5728\u975e\u6570\u636e\u5e93\u5b57\u6bb5\uff0c\u6267\u884c\u51fa\u9519");
            stringBuffer.append(fieldLower);
            return;
        } else {
            if (!columnSet.contains(fieldLower)) throw new SpiderException("\u5b58\u5728\u975e\u6570\u636e\u5e93\u5b57\u6bb5\uff0c\u6267\u884c\u51fa\u9519");
            stringBuffer.append(columnMap.get(fieldLower));
        }
    }

    @Override
    public E getById(PK primaryKey) {
        log.debug("----------> \u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5bf9\u8c61 : " + primaryKey);
        HashMap<String, PK> paramMap = new HashMap<String, PK>(1);
        paramMap.put("id", primaryKey);
        return (E)this.sqlSessionTemplate.selectOne(this.getByIdStatement(), paramMap);
    }

    @Override
    public List<E> getByIdList(List<PK> idList) {
        HashMap<String, List<PK>> map = new HashMap<String, List<PK>>(1);
        map.put("ids", idList);
        return this.sqlSessionTemplate.selectList(this.getListByIdsStatement(), map);
    }

    @Override
    public void updateById(E entity) {
        log.debug("----------> \u901a\u8fc7\u4e3b\u952e\u66f4\u65b0\u6570\u636e: " + entity);
        int count = this.sqlSessionTemplate.update(this.getUpdateStatement(), entity);
        log.debug("--------------> \u66f4\u65b0\u7684\u6570\u636e {} \u6761", (Object)count);
    }

    @Override
    public int deleteById(PK id) {
        log.debug("----------> \u901a\u8fc7\u4e3b\u952e\u5220\u9664\u6570\u636e : " + id);
        HashMap<String, PK> map = new HashMap<String, PK>(1);
        map.put("id", id);
        int affectCount = this.sqlSessionTemplate.delete(this.getDeleteStatement(), map);
        log.debug("--------------> \u5220\u9664\u6570\u636e {} \u6761", (Object)affectCount);
        return affectCount;
    }

    @Override
    public void deleteByIds(String checkIds) {
        log.debug("----------> \u901a\u8fc7\u4e3b\u952e\u5220\u9664\u6570\u636e : " + checkIds);
        if (StringUtils.isEmpty((Object)checkIds)) {
            return;
        }
        HashMap map = new HashMap(1);
        String[] split = checkIds.split(",");
        ArrayList<Long> longs = new ArrayList<Long>(split.length);
        for (String id : split) {
            if (StringUtils.isEmpty((Object)id)) continue;
            longs.add(Long.valueOf(id));
        }
        map.put("ids", longs);
        int affectCount = this.sqlSessionTemplate.delete(this.getDeleteByIdsStatement(), map);
        log.debug("--------------> \u5220\u9664\u6570\u636e {} \u6761", (Object)affectCount);
    }

    @Override
    @Deprecated
    public List findAll() {
        return this.sqlSessionTemplate.selectList(this.getPageStatementForAll(), null);
    }

    @Override
    public int updateBySql(String statementName, Object parameter) {
        return this.sqlSessionTemplate.update(this.getNameSpace() + "." + statementName, parameter);
    }

    @Override
    public int deleteBySql(String statementName, Object parameter) {
        return this.sqlSessionTemplate.delete(this.getNameSpace() + "." + statementName, parameter);
    }

    @Override
    public int insertBySql(String statementName, Object parameter) {
        return this.sqlSessionTemplate.insert(this.getNameSpace() + "." + statementName, parameter);
    }

    @Override
    public E selectOne(String statementName, Object parameter) {
        return (E)this.sqlSessionTemplate.selectOne(this.getNameSpace() + "." + statementName, parameter);
    }

    @Override
    public List selectList(String statementName, Object parameter) {
        return this.sqlSessionTemplate.selectList(this.getNameSpace() + "." + statementName, parameter);
    }

    @Override
    public Long selectCount(String statementName, Object parameter) {
        return (Long)this.sqlSessionTemplate.selectOne(this.getNameSpace() + "." + statementName, parameter);
    }

    protected String getNameSpace() {
        Type sType = this.getClass().getGenericSuperclass();
        Type[] generics = ((ParameterizedType)sType).getActualTypeArguments();
        Class mTClass = (Class)generics[0];
        return mTClass.getName() + "Mapper";
    }

    public String getInsertStatement() {
        return this.getNameSpace() + ".insert";
    }

    public String getBatchInsertStatement() {
        return this.getNameSpace() + ".inserts";
    }

    public String getUpdateStatement() {
        return this.getNameSpace() + ".updateById";
    }

    public String getDeleteStatement() {
        return this.getNameSpace() + ".deleteById";
    }

    public String getDeleteByIdsStatement() {
        return this.getNameSpace() + ".deleteByIds";
    }

    public String getPageStatementForPaging() {
        return this.getNameSpace() + ".findPage";
    }

    public String getPageStatementForAll() {
        return this.getNameSpace() + ".findAll";
    }

    public String getCountStatementForPaging() {
        return this.getNameSpace() + ".count";
    }

    public String getByIdStatement() {
        return this.getNameSpace() + ".getById";
    }

    private String getListByIdsStatement() {
        return this.getNameSpace() + ".getByIdList";
    }
}

