/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.spider.system.config.dbinterceptors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class KingbaseBatchSaveInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(KingbaseBatchSaveInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        System.out.println("KingbaseBatchSaveInterceptor\u62e6\u622a\u5668intercept()\u65b9\u6cd5\u6267\u884c\u4e86");
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        String originalSql = boundSql.getSql().trim();
        if (originalSql.toLowerCase().startsWith("insert")) {
            String modifiedSql = null;
            if (!this.isBatchInsert(originalSql) && !this.isSingleInsertWithNullId(invocation)) {
                modifiedSql = originalSql;
            } else {
                List parameterMappings = boundSql.getParameterMappings();
                this.replaceIdPlaceholdersWithSequence(originalSql, parameterMappings);
                modifiedSql = this.removeFirstColumnAndValue(originalSql, parameterMappings);
                System.out.println("modifiedSql=" + modifiedSql);
            }
            metaObject.setValue("delegate.boundSql.sql", (Object)modifiedSql);
        }
        return invocation.proceed();
    }

    private boolean isSingleInsertWithNullId(Invocation invocation) {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        String sql = boundSql.getSql();
        Pattern pattern = Pattern.compile("VALUES\\s*\\(([^)]+)\\)\\s*(,|$)", 2);
        Matcher matcher = pattern.matcher(sql);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 1) {
            String firstColumnName = this.getFirstColumnName(sql);
            if (StringUtils.isBlank((String)firstColumnName)) {
                log.error("\u672a\u83b7\u53d6\u5230\u7b2c\u4e00\u5217\u7684\u5217\u540d\uff0c\u65e0\u6cd5\u5224\u65ad\u5f53\u524dsql\u63d2\u5165\u662f\u5426\u6709\u4e3b\u952e\u4ee5\u53ca\u4e3b\u952e\u7684\u503c\u662f\u5426\u4e3a\u7a7a");
                return false;
            }
            String delegateBoundSql = (String)metaObject.getValue("delegate.boundSql.sql");
            System.out.println("delegateBoundSql.equals(sql)=" + delegateBoundSql.equals(sql));
            Connection connection = (Connection)invocation.getArgs()[0];
            String tableName = this.getTableName(sql);
            if (StringUtils.isBlank((String)tableName)) {
                log.error("\u672a\u83b7\u53d6\u5230\u8868\u540d\u79f0\uff0c\u65e0\u6cd5\u5224\u65ad\u5f53\u524dsql\u63d2\u5165\u662f\u5426\u6709\u4e3b\u952e\u4ee5\u53ca\u4e3b\u952e\u7684\u503c\u662f\u5426\u4e3a\u7a7a");
                return false;
            }
            try {
                boolean isFirstColumnPrimaryKey = this.isPrimaryKey(connection, tableName, firstColumnName);
                if (isFirstColumnPrimaryKey) {
                    return true;
                }
            }
            catch (Throwable var14) {
                log.error("\u5224\u65ad\u5217\u3010{}\u3011\u662f\u5426\u4e3a\u8868\u3010{}\u3011\u7684\u4e3b\u952e\u53d1\u751f\u5f02\u5e38", (Object)firstColumnName, (Object)tableName);
                var14.printStackTrace();
            }
        }
        return false;
    }

    private String getTableName(String sql) {
        Pattern pattern = Pattern.compile("INSERT INTO\\s+([\\w\\.]+)\\s*\\(", 2);
        Matcher matcher = pattern.matcher(sql);
        return matcher.find() ? matcher.group(1).trim() : null;
    }

    private String getFirstColumnName(String sql) {
        String columns;
        String[] columnArray;
        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s*\\(([^)]*)\\)", 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find() && (columnArray = (columns = matcher.group(1).trim()).split("\\s*,\\s*")).length > 0) {
            return columnArray[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPrimaryKey(Connection connection, String tableName, String columnName) throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet rs = metaData.getPrimaryKeys(null, null, tableName);){
            block16: while (rs.next()) {
                String pkColumnName = rs.getString("COLUMN_NAME");
                if (!pkColumnName.equalsIgnoreCase(columnName)) continue;
                ResultSet columnResultSet = metaData.getColumns(null, null, tableName, columnName);
                try {
                    String isAutoIncrement;
                    do {
                        if (!columnResultSet.next()) continue block16;
                    } while (!"YES".equalsIgnoreCase(isAutoIncrement = columnResultSet.getString("IS_AUTOINCREMENT")));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (columnResultSet == null) continue;
                    columnResultSet.close();
                }
            }
            return false;
        }
    }

    private boolean isBatchInsert(String sql) {
        Pattern pattern = Pattern.compile("(?i)\\)\\s*,\\s*\\(");
        Matcher matcher = pattern.matcher(sql);
        return matcher.find();
    }

    private void replaceIdPlaceholdersWithSequence(String sql, List<ParameterMapping> parameterMappings) {
        Pattern pattern = Pattern.compile("\\(\\s*\\?\\s*(,\\s*\\?\\s*)*\\)");
        Matcher matcher = pattern.matcher(sql);
        new StringBuffer();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        int parameterIndex = 0;
        while (matcher.find()) {
            String group = matcher.group();
            indexesToRemove.add(parameterIndex);
            parameterIndex += this.countQuestionMarks(group);
        }
        for (int i = indexesToRemove.size() - 1; i >= 0; --i) {
            int index = (Integer)indexesToRemove.get(i);
            if (index >= parameterMappings.size()) continue;
            parameterMappings.remove(index);
        }
    }

    private String removeFirstColumnAndValue(String sql, List<ParameterMapping> parameterMappings) {
        Pattern pattern = Pattern.compile("INSERT INTO\\s+\\w+\\s*\\(([^)]*)\\)\\s*VALUES\\s*(.*)", 34);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String columns = matcher.group(1).trim();
            String values = matcher.group(2).trim();
            String[] columnArray = columns.split("\\s*,\\s*");
            String[] valueGroups = values.split("\\)\\s*,\\s*\\(");
            if (columnArray.length > 1 && valueGroups.length != 0) {
                CharSequence[] updatedColumns = new String[columnArray.length - 1];
                System.arraycopy(columnArray, 1, updatedColumns, 0, columnArray.length - 1);
                ArrayList<String> updatedValueGroups = new ArrayList<String>();
                String[] var12 = valueGroups;
                int var13 = valueGroups.length;
                for (int var14 = 0; var14 < var13; ++var14) {
                    String valueGroup = var12[var14];
                    String cleanedValueGroup = valueGroup.replaceAll("[()]", "").trim();
                    String[] valueArray = cleanedValueGroup.split("\\s*,\\s*");
                    if (valueArray.length <= 1) continue;
                    CharSequence[] updatedValues = new String[valueArray.length - 1];
                    System.arraycopy(valueArray, 1, updatedValues, 0, valueArray.length - 1);
                    updatedValueGroups.add("(" + String.join((CharSequence)", ", updatedValues) + ")");
                }
                String updatedSql = "INSERT INTO " + sql.substring(12, matcher.start(1)) + String.join((CharSequence)", ", updatedColumns) + ") VALUES " + String.join((CharSequence)", ", updatedValueGroups);
                return updatedSql;
            }
            return sql;
        }
        return sql;
    }

    private int countQuestionMarks(String group) {
        int count = 0;
        int index = 0;
        while ((index = group.indexOf("?", index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    private String modifyBatchInsertSql(String originalSql, String sequenceName) {
        int valuesPos = originalSql.indexOf("VALUES");
        if (valuesPos == -1) {
            return originalSql;
        }
        String valuesClause = originalSql.substring(valuesPos + "VALUES".length()).trim();
        System.out.println("valuesClause=" + valuesClause);
        String modifiedValuesClause = valuesClause.replaceAll("\\(?,", "(nextval('" + sequenceName + "'), ");
        String newSql = originalSql.substring(0, valuesPos) + "VALUES " + modifiedValuesClause;
        System.out.println("newSql=" + newSql);
        return newSql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

